package de.duehl.swing.ui.buttons.painted;

import javax.swing.Icon;

/*
 * Copyright 2019 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Diese Klasse stellt einen Schalter mit einem Bild darauf dar.
 *
 * @version 1.01     2019-02-27
 * @author Christian Dühl
 */

public class IconButton extends PaintedButton {

    private static final long serialVersionUID = 1L;

    /** Konstruktor. */
    public IconButton(Icon icon) {
        super();
        setIcon(icon);
    }

    /** Zeichnet das Symbol in horizontaler und rechteckiger Anordnung. */
    @Override
    protected void paintHorizontalSymbolRectangle() {
        paintSymbol();
    }

    /** Zeichnet das Symbol in vertikaler und rechteckiger Anordnung. */
    @Override
    protected void paintVerticalSymbolRectangle() {
        paintSymbol();
    }

    /** Zeichnet das Symbol in horizontaler und quadratischer Anordnung. */
    @Override
    protected void paintHorizontalSymbolSquare() {
        paintSymbol();
    }

    /** Zeichnet das Symbol in vertikaler und quadratischer Anordnung. */
    @Override
    protected void paintVerticalSymbolSquare() {
        paintSymbol();
    }

    /** Zeichnet das Minus-Symbol Anordnung. */
    private void paintSymbol() {
        // hier wird schlicht nichts gezeichnet...
    }

}
