package de.duehl.swing.ui.buttons.painted;

import java.awt.Color;

import de.duehl.swing.ui.geometry.PixelPoint;

/**
 * Diese Klasse stellt einen kleinen Schalter zum Zurückschalten dar.
 * Eine quadratische Ansicht wird nicht unterstützt.
 *
 * @version 1.01     2025-07-23
 * @author Christian Dühl
 */

public class PreviousButton extends PaintedButton {

    private static final long serialVersionUID = -1L;


    /** Konstruktor. */
    public PreviousButton() {
        super(Color.BLACK);
    }

    /**
     * Konstruktor.
     *
     * @param symbolColor
     *            Die Farbe des Symbols.
     */
    public PreviousButton(Color symbolColor) {
        super(symbolColor);
    }

    /** Zeichnet das Symbol in horizontaler und rechteckiger Anordnung. */
    @Override
    protected void paintHorizontalSymbolRectangle() {
        paintHorizontalSymbol();
    }

    /** Zeichnet das Symbol in vertikaler und rechteckiger Anordnung. */
    @Override
    protected void paintVerticalSymbolRectangle() {
        paintVerticalSymbol();
    }

    /** Zeichnet das Symbol in horizontaler und quadratischer Anordnung. */
    @Override
    protected void paintHorizontalSymbolSquare() {
        paintHorizontalSymbol();
    }

    /** Zeichnet das Symbol in vertikaler und quadratischer Anordnung. */
    @Override
    protected void paintVerticalSymbolSquare() {
        paintVerticalSymbol();
    }

    /**
     * Zeichnet das Symbol in horizontaler Anordnung. isForceSquare() wird ignoriert.
     *
     *               1
     *             .   6
     *          .    .
     *       .    .
     *    .     .
     *  2     5
     *    .     .
     *       .    .
     *          .    .
     *             .   4
     *               3
     */
    private void paintHorizontalSymbol() {
        int delta = 6;
        int off = delta / 2;
        int left = delta;
        int right = getWidth() - delta - 1;
        int upper = delta;
        int lower = getHeight() - delta - 1;
        int hightCenter = getHeight() / 2;

        paintPolygon(
                new PixelPoint(right - off,   upper      ), //  1
                new PixelPoint(left,          hightCenter), //  2
                new PixelPoint(right - off,   lower      ), //  3
                new PixelPoint(right,         lower - off), //  4
                new PixelPoint(left + 3*off,  hightCenter), //  5
                new PixelPoint(right,         upper + off)  //  6
                );
    }

    /**
     * Zeichnet das Symbol in vertikaler Anordnung. isForceSquare() wird ignoriert.
     *
     *              2
     *           .     .
     *        .     5     .
     *     .     .     .     .
     *   1   .            .    3
     *     6                 4
     */
    private void paintVerticalSymbol() {
        int delta = 6;
        int off = delta / 2;
        int left = delta;
        int right = getWidth() - delta - 1;
        int upper = delta;
        int lower = getHeight() - delta - 1;
        int widthCenter = getWidth() / 2;

        paintPolygon(
                new PixelPoint(left,         lower - off  ), //  1
                new PixelPoint(widthCenter,  upper        ), //  2
                new PixelPoint(right,        lower - off  ), //  3
                new PixelPoint(right - off,  lower        ), //  4
                new PixelPoint(widthCenter,  upper + 3*off), //  5
                new PixelPoint(left + off,   lower        )  //  6
                );
    }

}
