package de.duehl.swing.ui.components.elements;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

import de.duehl.swing.ui.colors.Colorizer;

/**
 * Diese Klasse stellt ein Element mit einer Überschrift und einem Schalter, um etwas zu ändern,
 * etwa in einem Optionendialog dar.
 *
 * @version 1.01     2017-02-28
 * @author Christian Dühl
 */

public class TitleWithChangeButton {

    /** Überschrift. */
    private final JLabel titleLabel;

    /** Button zum ändern des Pfades zur Datei oder zum Verzeichnis. */
    private final JButton changeButton;

    /** Panel mit Überschrift, Pfad und Änderungsbutton. */
    private final Component panel;

    /**
     * Konstruktor.
     *
     * @param title
     *            Überschrift für das Element.
     */
    public TitleWithChangeButton(String title) {
        titleLabel = new JLabel(title);
        changeButton = new JButton("ändern");
        panel = createPanel();
    }

    /** Erzeugt den Panel mit Überschrift, Option und Änderungsbutton. */
    private Component createPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());

        panel.add(titleLabel, BorderLayout.CENTER);
        panel.add(changeButton, BorderLayout.EAST);

        return panel;
    }

    /** Getter für das Panel mit Überschrift, Pfad und Änderungsbutton. */
    public Component getPanel() {
        return panel;
    }

    /** Färbt alle Komponenten mit dem übergebenen Colorizer ein. */
    public void colorize(Colorizer colorizer) {
        colorizer.setColors(panel);
        colorizer.setColors(titleLabel);
        colorizer.setColors(changeButton);
    }

    /** Fügt einen ActionListener zum "ändern"-Schalter hinzu. */
    public void addButtonActionListener(ActionListener actionListener) {
        changeButton.addActionListener(actionListener);
    }

    /** Setter für den auf dem Änderungsbutton angezeigten Text. */
    public void setButtonText(String title) {
        changeButton.setText(title);
    }

    /** Setzt die bevorzugt Größe des Buttons. */
    public void setButtonPreferredSize(Dimension buttonDimension) {
        changeButton.setPreferredSize(buttonDimension);
    }

//    /** Aktiviert oder deaktiviert Textfeld und Button. */
//    public void setEnabled(boolean selected) {
//        fieldWithButton.setEnabled(selected);
//    }

    /** Löst ein Anklicken des Buttons aus. */
    public void clickButton() {
        changeButton.doClick();
    }

    /** Fügt einen KeyListener zum Textfeld hinzu. */
    public void addKeyListener(KeyListener keyListener) {
        changeButton.addKeyListener(keyListener);
    }

}
