package de.duehl.swing.ui.components.selections;

/*
 * Copyright 2021 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.Color;
import java.awt.Component;

import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

import de.duehl.swing.ui.colors.ColorTool;

/**
 * Diese Klasse stellt einen Renderer für eine Combobox dar.
 *
 * @version 1.01     2021-07-16
 * @author Christian Dühl
 */

class ColoredComboBoxRenderer extends DefaultListCellRenderer {

    private static final long serialVersionUID = 1L;
    private Color color;
    private Color antiColor;

    public ColoredComboBoxRenderer(Color color) {
        super();
        this.color = color;
        antiColor = ColorTool.anticolor(color);
    }

    public void setColor(Color color) {
        this.color = color;
        antiColor = ColorTool.anticolor(color);
    }

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index,
            boolean isSelected, boolean hasFocus) {
        Component component = super.getListCellRendererComponent(list, value, index, isSelected,
                hasFocus);
        if (!isSelected && !hasFocus) {
            component.setForeground(antiColor);
            component.setBackground(color);
        }
        else {
            component.setForeground(color);
            component.setBackground(antiColor);

        }
        this.setOpaque(true);
        return component;
    }

}
