package de.duehl.swing.ui.components.selections;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.components.selections.base.MultipleFileOrPathSelection;

/**
 *  Diese Klasse stellt die Auswahl mehrerer Verzeichnisse etwa in einem Optionendialog dar.
 *
 * @version 1.01     2017-03-01
 * @author Christian Dühl
 */

public class MultipleDirSelection extends MultipleFileOrPathSelection {

    /**
     * Konstruktor.
     *
     * @param title
     *            Überschrift für die Wahl dieser Datei oder dieses Verzeichnisses.
     * @param frameTitle
     *            Überschrift ganz oben über dem Rahmen.
     */
    public MultipleDirSelection(String title, String frameTitle) {
        super(title, frameTitle);
    }

    /**
     * Der Benutzer wählt die Datei oder das Verzeichnis aus.
     *
     * @param startDir
     *            Startverzeichnis.
     * @return Ausgewählte Benutzereingabe oder null bei Abbruch durch den Benutzer.
     */
    @Override
    protected String openPath(String startDir) {
        return GuiTools.openDirectory(startDir);
    }

}
