package de.duehl.swing.ui.components.selections.datetime.spinnermodels;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.util.ArrayList;
import java.util.List;

/**
 * Diese Klasse stellt das Modell für einen Spinner dar, in dem man eine Stunde ("00" bis "23")
 * auswählen kann.
 *
 * @version 1.01     2017-03-17
 * @author Christian Dühl
 */

public class HourSpinnerModel extends CyclingSpinnerListModel<String> {

    private static final long serialVersionUID = 1L;

    public HourSpinnerModel() {
        super(createHours());
    }

    private static List<String> createHours() {
        List<String> list = new ArrayList<>();

        for (int hour = 0; hour < 24; ++hour) {
            String hourString = Integer.toString(hour);
            if (hourString.length() < 2) {
                hourString = "0"  + hourString;
            }
            list.add(hourString);
        }

        return list;
    }

}
