package de.duehl.swing.ui.dragndrop;

/*
 * Copyright 2020 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Dieses Interface dient dazu, ein Objekt übergeben zu können, dass über Änderungen an den
 * Inhalten der Eingabefelder auf der graphischen Oberfläche des Editors zum Bearbeiten von
 * Impressumdaten aus den Eingabefeldern informiert wird, ohne sich Abhängigkeiten von der gesamten
 * ImpressumEditorGui-Klasse einzuhandeln. Es wird dann veranlasst, die Daten aus der Oberfläche in
 * die zugehörigen Daten-Objekte zu sichern.
 *
 * @version 1.01     2020-01-16
 * @author Christian Dühl
 */

public interface ChangeInformer {

    /**
     * Wird aufgerufen, wenn sich der Inhalt der Datenfelder geändert hat. Es werden die
     * Suchbegriffe ermittelt und das aktuelle Dokument eingefärbt angezeigt.
     */
    void informAboutChangingData();

}
