package de.duehl.swing.ui.dragndrop.file;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DnDConstants;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.util.List;

/**
 * Dieses Klasse stellt eine Basis für einen DropTargetListener für das Ziehen von Dateien auf
 * ein Gui-Element.
 *
 * @version 1.01     2017-05-29
 * @author Christian Dühl
 */

public abstract class FileDropTargetListener implements DropTargetListener {

    @Override
    public void dragEnter(DropTargetDragEvent event) {
        // nichts
    }

    @Override
    public void dragOver(DropTargetDragEvent event) {
        // nichts
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent event) {
        // nichts
    }

    @Override
    public void dragExit(DropTargetEvent event) {
        // nichts
    }

    @Override
    public void drop(DropTargetDropEvent event) {
        event.acceptDrop(DnDConstants.ACTION_COPY);

        Transferable transferable = event.getTransferable();

        for (DataFlavor flavor : transferable.getTransferDataFlavors()) {
            try {
                if (flavor.isFlavorJavaFileListType()) {
                    @SuppressWarnings("unchecked")
                    List<File> files = (List<File>) transferable.getTransferData(flavor);

                    for (File file : files) {
                        useFile(file.getPath());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        event.dropComplete(true);
    }

    /** Dieser Methode wird jeder gedraggte Dateinamen übergeben. */
    abstract protected void useFile(String filename);

}
