package de.duehl.swing.ui.elements;

import java.awt.BorderLayout;
import java.awt.Component;

import javax.swing.JPanel;
import javax.swing.JSplitPane;

/**
 * Diese Klasse stellt drei übereinander angeordnete Bereiche mit jeweils eine horizontalen
 * Trennlinie (eine "vertikale" JSplitPane) dar.
 *
 * @version 1.01     2017-03-29
 * @author Christian Dühl
 */

public class DoubleVerticalSplitPane {

    private final Component upper;
    private final Component middle;
    private final Component lower;
    private final JSplitPane upperSplit;
    private final JSplitPane lowerSplit;
    private final JPanel panel;

    public DoubleVerticalSplitPane(Component upper, Component middle, Component lower) {
        this.upper = upper;
        this.middle = middle;
        this.lower = lower;
        upperSplit = new JSplitPane(JSplitPane.VERTICAL_SPLIT);
        lowerSplit = new JSplitPane(JSplitPane.VERTICAL_SPLIT);
        panel = new JPanel();

        fillUpperSplitPane();
        fillLowerSplitPane();
        buildPanel();
    }

    private void fillUpperSplitPane() {
        upperSplit.setLeftComponent(upper);
        upperSplit.setRightComponent(lowerSplit);
    }

    private void fillLowerSplitPane() {
        lowerSplit.setLeftComponent(middle);
        lowerSplit.setRightComponent(lower);
    }

    private Component buildPanel() {
        panel.setLayout(new BorderLayout());

        panel.add(upperSplit, BorderLayout.CENTER);

        return panel;
    }

    public JPanel getPanel() {
        return panel;
    }

    public JSplitPane getUpperSplit() {
        return upperSplit;
    }

    public JSplitPane getLowerSplit() {
        return lowerSplit;
    }

}
