package de.duehl.swing.ui.elements.pictures;

/*
 * Copyright 2024 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

/**
 * Diese Klasse stellt Hilfsmethoden rund um die Anzeige von Kapiteln zur Verfügung.
 *
 * @version 1.01     2024-02-07
 * @author Christian Dühl
 */

public class PicturePanelHelper {

    /**
     * Erzeugt einen MouseWheelListener zum Scrollen über den Bildern, um damit vor- oder zurück zu
     * blättern.
     *
     * @param reactor
     *            Die Komponente die auf das Scrollen reagiert.
     * @return Den erzeugten MouseWheelListener.
     */
    public static MouseWheelListener createMouseWheelListener(MouseWheelReactor reactor) {
        return new MouseWheelListener() {
            @Override
            public void mouseWheelMoved(MouseWheelEvent event) {
                int notches = event.getWheelRotation();
                if (notches < 0) {
                    reactor.mouseWheelUp(-notches);
                }
                else {
                    reactor.mouseWheelDown(notches);
                }
            }
        };
    }

    /**
     * Erzeugt einen MouseWheelListener zum Scrollen über den Bildern, um damit vor- oder zurück zu
     * blättern.
     *
     * @param reactor
     *            Die Komponente die auf das Scrollen reagiert.
     * @return Den erzeugten MouseWheelListener.
     */
    public static MouseWheelListener createVerbooseMouseWheelListener() {
        return new MouseWheelListener() {
            @Override
            public void mouseWheelMoved(MouseWheelEvent event) {
                String message;
                int notches = event.getWheelRotation();
                if (notches < 0) {
                    message = "Mouse wheel moved UP " + -notches + " notch(es)";
                }
                else {
                    message = "Mouse wheel moved DOWN " + notches + " notch(es)";
                }
                if (event.getScrollType() == MouseWheelEvent.WHEEL_UNIT_SCROLL) {
                    message += "    Scroll type: WHEEL_UNIT_SCROLL\n";
                    message += "    Scroll amount: " + event.getScrollAmount()
                            + " unit increments per notch\n";
                    message += "    Units to scroll: " + event.getUnitsToScroll()
                            + " unit increments\n";
                }
                else { // scroll type == MouseWheelEvent.WHEEL_BLOCK_SCROLL
                    message += "    Scroll type: WHEEL_BLOCK_SCROLL";
                }
                System.out.println(message);
            }
        };
    }

}
