package de.duehl.swing.ui.highlightingeditor.syntax;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.Color;

/**
 * Diese Klasse stellt eine Art der Syntax-Hervorhebung des bearbeitbaren Editors mit
 * Syntax-Highlighting dar.
 *
 * @version 1.01     2017-11-15
 * @author Christian Dühl
 */

public class HighlightingType {

    /** Die zu verwendende Farbe. */
    private final Color color;

    /** Gibt an, ob der Begriff fett dargestellt werden soll. */
    private final boolean bold;

    /** Gibt an, ob Treffer auch Wortteile auszeichnen. */
    private final boolean markInWordParts;

    /**
     * Konstruktor.
     *
     * @param color
     *            Die zu verwendende Farbe.
     */
    public HighlightingType(Color color) {
        this(color, false);
    }

    /**
     * Konstruktor.
     *
     * @param color
     *            Die zu verwendende Farbe.
     * @param bold
     *            Gibt an, ob der Begriff fett dargestellt werden soll.
     */
    public HighlightingType(Color color, boolean bold) {
        this(color, bold, false);
    }

    /**
     * Konstruktor.
     *
     * @param color
     *            Die zu verwendende Farbe.
     * @param bold
     *            Gibt an, ob der Begriff fett dargestellt werden soll.
     * @param markInWordParts
     *            Gibt an, ob Treffer auch Wortteile auszeichnen.
     */
    public HighlightingType(Color color, boolean bold, boolean markInWordParts) {
        this.color = color;
        this.bold = bold;
        this.markInWordParts = markInWordParts;
    }

    /** Getter für die zu verwendende Farbe. */
    public Color getColor() {
        return color;
    }

    /** Gibt an, ob der Begriff fett dargestellt werden soll. */
    public boolean isBold() {
        return bold;
    }

    /** Gibt an, ob Treffer auch Wortteile auszeichnen. */
    public boolean isMarkInWordParts() {
        return markInWordParts;
    }

    @Override
    public String toString() {
        return "HighlightingType [color=" + color + ", bold=" + bold + ", markInWordParts="
                + markInWordParts + "]";
    }

}
