package de.duehl.swing.ui.layout.card;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Dieses Interface wird von den Klassen mit den Logiken der Karten implementiert.
 *
 * @version 1.01     2016-12-07
 * @author Christian Dühl
 */

public abstract class CardLogic {

    /** Zugehörige Karte. */
    private Card card;

    /** Alle Karten. */
    private Cards cards;

    /** Setter für die zugehörige grafische Oberfläche. */
    public abstract void setGui(CardGui gui);

    /** Setter für alle Karten. */
    final void setCards(Cards cards) {
        this.cards = cards;
    }

    /** Getter für alle Karten. */
    public final Cards getCards() {
        return cards;
    }

    /** Setter für die zugehörige Karte. */
    final void setCard(Card card) {
        this.card = card;
    }

    /** Getter für die zugehörige Karte. */
    protected final Card getCard() {
        return card;
    }

    /** Getter für die Nummer des aktuellen Schritts (1-basiert). */
    public final int getStepNumber() {
        return card.getStepNumber();
    }

    /** Getter für den Namen des Schrittes, wie er in der Oberfläche angezeigt werden soll. */
    public final String getNameForGui() {
        return card.getNameForGui();
    }

    /** Setter für das Ergebnis von der Karte vor der zu dieser Logik gehörenden Karte. */
    public abstract void setResultFromPreviousCard(CardResult previousResult);

    /** Wird aufgerufen, wenn die Karte angezeigt wird. Wird nicht für die erste Karte aufgerufen. */
    public abstract void runWhenShown();

    /** Getter für das Ergebnis dieser Karte. */
    abstract public CardResult getResult();

    /** Wird aufgerufen, wenn der Benutzer das Programm im laufenden Betrieb beendet. */
    abstract public void quit();

}
