package de.duehl.swing.ui.move;

/*
 * Copyright 2025 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.BorderLayout;

import javax.swing.JPanel;

import de.duehl.swing.ui.move.data.VerticalMoveButtonsUser;

/**
 * Diese Klasse stellt einen Panel dar, den man zwischen der Anzeige von vier Buttons um Dinge nach
 * oben, unten, ganz nach oben oder ganz nach unten zu bewegen und 'nichts' umschalten kann.
 *
 * @version 1.01     2025-06-18
 * @author Christian Dühl
 */

public class SwitchableVerticalMoveButtons {

    /**
     * Stellt die vier Buttons dar, um Dinge nach oben, unten, ganz nach oben oder ganz nach unten
     * zu bewegen.
     */
    private final VerticalMoveButtons moveButtons;

    /** Der umschaltbare Panel mit Buttons zum Verschieben nach oben und unten. */
    private final JPanel panel;

    /** Gibt an, ob die Buttons zum Verschieben angezeigt werden. */
    private boolean moveButtonsShown;

    /**
     * Konstruktor.
     *
     * @param moveButtonsUser
     *            Das Objekt, das die Buttons zum verschieben anzeigt und verwendet.
     */
    public SwitchableVerticalMoveButtons(VerticalMoveButtonsUser moveButtonsUser) {
        moveButtons = new VerticalMoveButtons(moveButtonsUser);

        panel = new JPanel();
        moveButtonsShown = false;

        init();
    }

    private void init() {
        initSwitchableMoveUpAndDownButtonsPanel();
    }

    private void initSwitchableMoveUpAndDownButtonsPanel() {
        panel.setLayout(new BorderLayout());

    }

    /**
     * Zeigt die Buttons zum Verschieben an oder blendet wie aus.
     *
     * Der Aufrufer sollte danach
     *     panel.repaint();
     * aufrufen.
     */
    public void showMoveButtons(boolean showMoveButtons) {
        if (showMoveButtons) {
            showMoveButtons();
        }
        else {
            hideMoveButtons();
        }
    }

    /**
     * Zeigt die Buttons zum Bewegen an.
     *
     * Der Aufrufer sollte danach
     *     panel.repaint();
     * aufrufen.
     */
    private void showMoveButtons() {
        panel.removeAll();
        panel.add(moveButtons.getPanel(), BorderLayout.CENTER);
        panel.repaint();
        moveButtonsShown = true;
    }

    /**
     * Versteckt die Buttons zum Bewegen.
     *
     * Der Aufrufer sollte danach
     *     panel.repaint();
     * aufrufen.
     */
    private void hideMoveButtons() {
        panel.removeAll();
        panel.add(new JPanel(), BorderLayout.CENTER);
        panel.repaint();
        moveButtonsShown = false;
    }

    /**
     * Setzt die Farben und Darstellung der Buttons abhängig davon, ob sie verschoben werden
     * können.
     */
    public void setUpAndDownButtonColorsAndEnabled() {
        moveButtons.setUpAndDownButtonColorsAndEnabled();
    }

    /** Getter für den umschaltbaren Panel mit Buttons zum Verschieben nach oben und unten. */
    public JPanel getPanel() {
        return panel;
    }

    /** Gibt an, ob die Buttons zum Verschieben angezeigt werden. */
    public boolean isMoveButtonsShown() {
        return moveButtonsShown;
    }

}
