package de.duehl.swing.ui.move.data;

/*
 * Copyright 2025 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Dieses Interface steht für die grafische Oberfläche, welche Bars bewegt und angeben kann, ob die
 * Bewegung zulässig ist.
 *
 * @version 1.01     2025-07-19
 * @author Christian Dühl
 */

public interface MovingGui<Bar> {

    /** Gibt an, ob die übergebene Bar nach oben bewegt werden kann. */
    boolean canBarMoveUp(Bar bar);

    /** Gibt an, ob die übergebene Bar nach unten bewegt werden kann. */
    boolean canBarMoveDown(Bar bar);

    /** Verschiebt die übergebene Bar an die erste Stelle. */
    void moveBarToFirst(Bar bar);

    /** Verschiebt die übergebene Bar nach oben. */
    void moveBarUp(Bar bar);

    /** Verschiebt die übergebene Bar nach unten. */
    void moveBarDown(Bar bar);

    /** Verschiebt die übergebene Bar an die letzte Stelle. */
    void moveBarToLast(Bar bar);

}
