package de.duehl.swing.ui.tabs.bars.editors;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.Component;

import de.duehl.swing.ui.tabs.bars.generic.TabBar;

/**
 * Diese Klasse stellt ein Reiterelement dar, welches eine Reihe von Editoren aufnimmt.
 * Dabei wird in jeden Reiter oben ein eigenes Tabulator-Objekt eingefügt, das anzeigen kann,
 * ob der Inhalt des Reiters geändert wurde oder unverändert ist.
 *
 * @version 1.01     2017-12-07
 * @author Christian Dühl
 */

public class TabBarWithEditors extends TabBarWithEditorsBase {

    /** Konstruktor für Reiter mit Schalter zum Schließen. */
    public TabBarWithEditors() {
        this(true);
    }

    /**
     * Konstruktor.
     *
     * @param showCloseButton
     *            Gibt an, ob der Button zum Löschen angezeigt werden soll.
     */
    public TabBarWithEditors(boolean showCloseButton) {
        setShowCloseButton(showCloseButton);
        setTabBar(createTabBar(showCloseButton));
        createAndAddChangeListener();
    }

    private TabBar<Component> createTabBar(boolean showCloseButton) {
        return new TabBar<>(showCloseButton);
    }

}
