package de.duehl.swing.ui.undoredo.resources;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import de.duehl.swing.ui.resources.IconLoader;

public class IconDefinitions {

    public static final String HISTORY_PREVIOUS = "HISTORY_PREVIOUS";
    public static final String HISTORY_NEXT = "HISTORY_NEXT";

    /**
     * Erzeugt einen IconLoader mit allen Bilddefinitionen.
     *
     * @return IconLoader
     */
    public IconLoader createIconLoader() {
        IconLoader iconLoader = new IconLoader(this.getClass(), null); // Kein Programm-Icon!!

        /* Historie: */
        iconLoader.addPictureIdentifier(HISTORY_PREVIOUS, "rueckgaengig.gif");
        iconLoader.addPictureIdentifier(HISTORY_NEXT, "wiederholung.gif");

        return iconLoader;
    }

}
