package de.duehl.swing.ui;

/*
 * Copyright 2024 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import org.junit.Test;

import de.duehl.basics.text.Text;

public class GuiToolsTest {

    @Test
    public void toVerticalButtonText() {
        String text = "abc";
        String actual = GuiTools.toVerticalButtonText(text);
        String expected = "<html>a<br>b<br>c</html>";
        assertEquals(expected, actual);
    }

    @Test
    public void createHtmlTextForButtonsWithUnderscoreReplacementWithShortTextWithoutUnderscores() {
        String text = "Anzuzeigender Text";
        int maxTextLenght = 60;
        String actual = GuiTools.createHtmlTextForButtonsWithUnderscoreReplacement(text,
                maxTextLenght);
        String expected = "<html>Anzuzeigender Text</html>";
        assertEquals(expected, actual);
    }

    @Test
    public void createHtmlTextForButtonsWithUnderscoreReplacementWithLongTextWithoutUnderscores() {
        String text = "Anzuzeigender Text";
        int maxTextLenght = 15;
        String actual = GuiTools.createHtmlTextForButtonsWithUnderscoreReplacement(text,
                maxTextLenght);
        String expected = "<html>Anzuzeigender<br/>" + Text.LINE_BREAK + "Text</html>";
        assertEquals(expected, actual);
    }

    @Test
    public void createHtmlTextForButtonsWithUnderscoreReplacementWithLongTextWithUnderscores() {
        String text =
                "As_a_Reincarnated_Aristocrat,_I'll_Use_My_Appraisal_Skill_to_Rise_in_the_World";
        int maxTextLenght = 50;
        String actual = GuiTools.createHtmlTextForButtonsWithUnderscoreReplacement(text,
                maxTextLenght);
        String expected = "<html>As a Reincarnated Aristocrat, I'll Use My<br/>"
                + Text.LINE_BREAK + "Appraisal Skill to Rise in the World</html>";
        assertEquals(expected, actual);
    }

    @Test
    public void createHtmlTextForButtonsWithShortText() {
        String text = "Anzuzeigender Text";
        int maxTextLenght = 60;
        String actual = GuiTools.createHtmlTextForButtons(text, maxTextLenght);
        String expected = "<html>Anzuzeigender Text</html>";
        assertEquals(expected, actual);
    }

    @Test
    public void createHtmlTextForButtonsWithLongText() {
        String text = "Anzuzeigender Text";
        int maxTextLenght = 15;
        String actual = GuiTools.createHtmlTextForButtons(text, maxTextLenght);
        String expected = "<html>Anzuzeigender<br/>" + Text.LINE_BREAK + "Text</html>";
        assertEquals(expected, actual);
    }

}
