package de.duehl.swing.ui.start;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.io.File;

import javax.swing.JFileChooser;

import de.duehl.swing.ui.filefilter.FilterFileFilter;

public class FilterFileFilterTest {

    public static void main(String[] args) {
        JFileChooser fc = new JFileChooser();
        fc.setFileFilter(new FilterFileFilter());

        int state = fc.showSaveDialog(null);
        if (state == JFileChooser.APPROVE_OPTION) {
            File file = fc.getSelectedFile();
            System.out.println("Selected File = " + file);
        }
        else {
            System.out.println("Filtern vom Benutzer abgebrochen!");
        }
    }

}
