package de.duehl.swing.ui.start;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.Color;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

import de.duehl.swing.ui.GuiTools;

public class TitledBordersForPanelTest {

    private final static boolean USE_NICE_GUI = true;

    public static void main(String[] args) {
        if (USE_NICE_GUI) {
            GuiTools.setNiceLayoutManager();
        }

        JFrame frame = new JFrame("Titled borders for panel demo");
        frame.setLayout(new GridLayout(6, 1, 5, 5));

        for (JPanel panel : createSixPanels()) {
            frame.add(panel);
        }

        frame.setSize(800, 600);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setVisible(true);
    }

    private static List<JPanel> createSixPanels() {
        List<JPanel> panels = new ArrayList<>();

        panels.add(createFirstPanel());
        panels.add(createSecondPanel());
        panels.add(createThirdPanel());
        panels.add(createFourthPanel());
        panels.add(createFifthPanel());
        panels.add(createSixthPanel());

        return panels;
    }

    private static JPanel createFirstPanel() {
        JPanel panel = new JPanel();
        GuiTools.createTitle(panel);
        panel.add(new JLabel("GuiTools.createTitle(panel)"));
        return panel;
    }

    private static JPanel createSecondPanel() {
        JPanel panel = new JPanel();
        GuiTools.createBlueTitle("blue title", panel);
        panel.add(new JLabel("GuiTools.createBlueTitle(\"blue title\", panel)"));
        return panel;
    }

    private static JPanel createThirdPanel() {
        JPanel panel = new JPanel();
        GuiTools.createTitle("colored title", panel, Color.RED);
        panel.add(new JLabel("GuiTools.createTitle(\"create Title\", panel, Color.RED)"));
        return panel;
    }

    private static JPanel createFourthPanel() {
        JPanel panel = new JPanel();
        GuiTools.createTitledBorder("titled border", panel);
        panel.add(new JLabel("GuiTools.createTitledBorder(\"titled border\", panel)"));
        return panel;
    }

    private static JPanel createFifthPanel() {
        JPanel panel = new JPanel();
        GuiTools.createTitledBorder("colored titled border", panel, Color.MAGENTA);
        panel.add(new JLabel(
                "GuiTools.createTitledBorder(\"colored titled border\", panel, Color.MAGENTA)"));
        // TODO Auto-generated method stub
        return panel;
    }

    private static JPanel createSixthPanel() {
        JPanel panel = new JPanel();
        // TODO Auto-generated method stub
        return panel;
    }

}
