package de.duehl.swing.ui.start.card.a.input;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

import de.duehl.swing.ui.layout.card.CardGui;
import de.duehl.swing.ui.layout.card.CardLogic;
import de.duehl.swing.ui.layout.card.CardSwitcher;

public class InputCardGui implements CardGui {

    private CardSwitcher switcher;
    private JTextField inputField;
    private InputCardLogic logic;

    @Override
    public void setLogic(CardLogic logic) {
        if (logic instanceof InputCardLogic) {
            this.logic = (InputCardLogic) logic;
        }
        else {
            throw new RuntimeException("Aufruf mit der falschen Logik!");
        }
    }

    @Override
    public Component createGui(CardSwitcher switcher) {
        this.switcher = switcher;

        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());

        panel.add(createTitleLabel(), BorderLayout.NORTH);
        panel.add(createInputPanel(), BorderLayout.CENTER);
        panel.add(createButtonPanel(), BorderLayout.SOUTH);

        return panel;
    }

    private Component createTitleLabel() {
        JLabel label = new JLabel("Bitte geben sie eine ganze Zahl ein:");
        return label;
    }

    private Component createInputPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());

        panel.add(createInputTextField(), BorderLayout.CENTER);

        return panel;
    }

    private Component createInputTextField() {
        inputField = new JTextField();
        return inputField;
    }

    private Component createButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());

        panel.add(createNextButton(), BorderLayout.EAST);

        return panel;
    }

    private Component createNextButton() {
        JButton button = new JButton("weiter");

        button.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                apply();
            }
        });

        return button;
    }

    private void apply() {
        String value = inputField.getText().trim();
        boolean success = logic.calculateResult(value);
        if (success) {
            switcher.switchCard();
        }
        else {
            JOptionPane.showMessageDialog(null,
                    "Ihre Eingabe ist fehlerhaft!",
                    "Es ist ein Fehler aufgetreten...",
                    JOptionPane.INFORMATION_MESSAGE);
        }
    }

    @Override
    public void cleanUp() {
        // Hier muss nichts aufgeräumt werden...
    }

}
