package de.duehl.swing.ui.start.enter;

/*
 * Copyright 2022 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

import de.duehl.swing.ui.dialogs.values.EnterValueDialog;

public class EnterValueDialogTest {

    public static void main(String[] args) {
        new EnterValueDialogTest();
    }

    /** Konstruktor. */
    public EnterValueDialogTest() {
        SwingUtilities.invokeLater(new Runnable() {
            @Override
            public void run() {
                createGUI();
            }
        });
    }

    private void createGUI() {
        JFrame frame = new JFrame("EnterValueDialog - Test");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setLayout(new BorderLayout());

        JButton runButton = new JButton("Start");
        frame.add(runButton, BorderLayout.CENTER);
        runButton.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                createDialog(frame);
            }
        });

        frame.setPreferredSize(new Dimension(300, 200));
        frame.setLocation(300, 200);
        frame.pack();
        frame.setVisible(true);
    }

    private void createDialog(JFrame frame) {
        EnterValueDialog dialog = new EnterValueDialog(
                frame.getLocation(), null, "Eingabetest",
                "Bitte geben Sie etwas ein:", "Vorbelegung");
        dialog.setVisible(true);
        String value = dialog.getEnteredValue();
        System.out.println("Ausgabe: [" + value + "]");
    }

}
