package de.duehl.swing.ui.start.filter.project.data;

/**
 * Diese Enum-Klasse stellt den Eintragstyp dar.
 *
 * @version 1.01     2016-08-09
 * @author Christian Dühl
 */

public enum EntryType {

    UNBEKANNT("?", "?"),
    NEUEINTRAG("N", "normal"),
    ERWEITERUNG("E", "erweiterung"),
    AENDERUNG("A", "aenderung"),
    BERICHTIGUNG("B", "berichtigung");

    private final String singelChar;
    private final String text;

    EntryType(String singelChar, String text) {
        this.singelChar = singelChar;
        this.text = text;
    }

    public String asSingleChar() {
        return singelChar;
    }

    public String getText() {
        return text;
    }

    public static EntryType determineFromCapitalLetter(String typeAsCapitalLetter) {
        for (EntryType type : values()) {
            if (type.asSingleChar().equals(typeAsCapitalLetter)) {
                return type;
            }
        }
        return EntryType.UNBEKANNT;
    }

    public static EntryType determineFromText(String text) {
        for (EntryType type : values()) {
            if (text.equals(type.text)) {
                return type;
            }
        }
        return EntryType.UNBEKANNT;
    }

}
