package de.duehl.swing.ui.start.listdialog.ui;

import java.awt.Component;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.colors.ColorTool;
import de.duehl.swing.ui.dialogs.lists.logic.LogicalEditableList;
import de.duehl.swing.ui.dialogs.lists.ui.EditableListElement;
import de.duehl.swing.ui.dialogs.lists.ui.UiElementListModifier;
import de.duehl.swing.ui.start.listdialog.logic.DemoLogicalElement;

public class DemoUiElement extends EditableListElement<DemoLogicalElement> {

    public DemoUiElement(DemoLogicalElement element,
            LogicalEditableList<DemoLogicalElement> logicalEditableList,
            UiElementListModifier<DemoLogicalElement> uiElementListModifier) {
        super(element, logicalEditableList, uiElementListModifier);
    }

    /** Erzeugt die grafische Darstellung des logischen Elements ohne die Buttons drumherum. */
    @Override
    protected Component createElementComponent() {
        DemoLogicalElement element = getLogicalElement();
        String text = element.getText();
        JLabel label = new JLabel(text);
        GuiTools.biggerFont(label, 5);
        label.setBorder(new EmptyBorder(0, 3, 0, 3));

        label.setForeground(ColorTool.getColorByName(TITLE_COLOR));

        GuiTools.boldFont(label);

        return label;
    }

    /**
     * Bearbeitet das hinterlegte, logische Element in einem passenden Dialog.
     *
     * @param parentComponent
     *            Komponente, vor der die Bearbeitung angezeigt werden soll.
     */
    @Override
    public void editElement(Component parentComponent) {
        DemoLogicalElement element = getLogicalElement();
        String text = element.getText();
        String userInput = GuiTools.askUserToEnterAStringValue(parentComponent,
                "Bitte den Wert eingeben", "Neuer Wert", text);
        if (!userInput.isEmpty()) {
            element.setText(userInput);
            updateElementsPanel();
        }
    }

    /** Erzeugt einen Button zur Auswahl des Elements im Select-Dialog. */
    @Override
    public final JButton createSelectButton() {
        DemoLogicalElement element = getLogicalElement();
        String text = element.getText();
        JButton button = new JButton(text);
        button.setForeground(ColorTool.getColorByName(TITLE_COLOR));
        return button;
    }

}
