package de.duehl.swing.ui.start.size;

/*
 * Copyright 2020 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.List;

import javax.swing.JButton;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.dialogs.base.NonModalFrameDialogBase;
import de.duehl.swing.ui.elements.size.SizeChooser;

/**
 * Diese Klasse testet den Dialog zur Auswahl einer Größe.
 *
 * @version 1.01     2020-11-03
 * @author Christian Dühl
 */

public class SizeChooserTest extends NonModalFrameDialogBase {

    private static final Dimension DIALOG_DIMENSION = new Dimension(400, 200);

    private int size;
    private final JButton sizeChangeButton;

    /** Konstruktor. */
    public SizeChooserTest() {
        super("SizeChooser Test", DIALOG_DIMENSION);

        size = 5;
        sizeChangeButton = new JButton();

        initSizeColorButton();

        fillDialog();
    }

    /** Baut die Gui auf. */
    @Override
    protected void populateDialog() {
        add(sizeChangeButton, BorderLayout.CENTER);
    }

    private void initSizeColorButton() {
        setSizeButtonText();
        sizeChangeButton.addActionListener(e -> selectSize());
    }

    private void selectSize() {
        String description = "Vergrößerung des Buttontextes";
        int rows = 2;
        int columns = 5;
        List<Integer> possibleSizes = CollectionsHelper.buildListFrom(
                1,  2,  3,  4,  5,
                6,  7,  8,  9, 10
                );
        SizeChooser chooser = new SizeChooser(size, description, rows, columns,
                possibleSizes, getLocation(), null);
        chooser.setSize(size);
        chooser.setVisible(true);
        int newsize = chooser.getSize();
        if (newsize != SizeChooser.NO_VALUE_SELECTED) {
            size = newsize;
            setSizeButtonText();
        }
    }

    private void setSizeButtonText() {
        sizeChangeButton.setText("additive Größe des Textes ändern, momentan " + size);
    }

    /** Startpunkt des Programms, Parameter werden ignoriert. */
    public static void main(String[] args) {
        GuiTools.setNiceLayoutManager();
        new SizeChooserTest().setVisible(true);
    }

}
