package de.duehl.swing.ui.start.timedate;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.BorderLayout;
import java.awt.Component;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

import de.duehl.basics.datetime.date.Weekday;
import de.duehl.swing.data.DailyWeeklyNot;
import de.duehl.swing.data.MinuteHour;
import de.duehl.swing.ui.components.selections.datetime.DailyWeeklyNotSelector;

public class DailyWeeklyNotSelectorTest {

    private final DailyWeeklyNotSelector selector;

    public DailyWeeklyNotSelectorTest() {
        selector = new DailyWeeklyNotSelector();
        selector.initValues(createInitialValues());
        SwingUtilities.invokeLater(this::createFrame);
    }

    private DailyWeeklyNot createInitialValues() {
        DailyWeeklyNot initial = new DailyWeeklyNot();

        initial.setDailyTime(new MinuteHour("05:00"));
        initial.setWeekly();
        initial.setWeeklyTime(new MinuteHour("19:00"));
        initial.setWeeklyWeekday(Weekday.SUNDAY);

        System.out.println("Initiale Werte: " + initial);

        return initial;
    }

    private void createFrame() {
        JFrame frame= new JFrame();
        frame.setTitle("Testprogramm zum Wählen eines Wochentages.");

        frame.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        frame.setLayout(new BorderLayout());

        frame.add(selector.getPanel(), BorderLayout.CENTER);
        frame.add(createPrintWeekdayButton(), BorderLayout.SOUTH);

        frame.pack();
        frame.setVisible(true);
    }

    private Component createPrintWeekdayButton() {
        JButton button = new JButton("Print");
        button.addActionListener(e -> print());
        return button;
    }

    private void print() {
        DailyWeeklyNot dailyWeeklyNot = selector.getUserSelection();
        System.out.println(dailyWeeklyNot);
    }

    public static void main(String[] args) {
        new DailyWeeklyNotSelectorTest();
    }

}
