package de.duehl.threads.start;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import de.duehl.threads.BusyRunnable;
import de.duehl.threads.timed.TimedThreadRunner;
import de.duehl.threads.timed.TimedThreadRunner.TaskState;

public class TimedThread2 {

    public static void main(String[] args) {
        int secondsTaskIsRunning = 10;
        int secondsBeforeKill = 20;
        int secondsBetweenWatching = 2;

        BusyRunnable runnable = new BusyRunnable(secondsTaskIsRunning);
        TimedThreadRunner runner = new TimedThreadRunner(secondsBeforeKill,
                1000L * secondsBetweenWatching, runnable);
        System.out.println("VOR runner.runTask()");
        runner.runTask();
        System.out.println("NACH runner.runTask()");
        TaskState state = runner.getTaskState();
        System.out.println("State : " + state);
    }

}

/*

VOR runner.runTask()
Prüfung zu Beginn in Ordnung.
Warte 2 Sekunden...
- BusyRunnable Berechnung: 2
- BusyRunnable Berechnung: 15
- BusyRunnable Berechnung: 25
- BusyRunnable Berechnung: 39
Abbruchzeit noch nicht erreicht:
    Abbruch nach: 20
    Bisher      : 2
Warte 2 Sekunden...
- BusyRunnable Berechnung: 51
- BusyRunnable Berechnung: 65
- BusyRunnable Berechnung: 77
- BusyRunnable Berechnung: 81
Abbruchzeit noch nicht erreicht:
    Abbruch nach: 20
    Bisher      : 4
Warte 2 Sekunden...
- BusyRunnable Berechnung: 101
- BusyRunnable Berechnung: 125
- BusyRunnable Berechnung: 128
- BusyRunnable Berechnung: 140
Abbruchzeit noch nicht erreicht:
    Abbruch nach: 20
    Bisher      : 6
Warte 2 Sekunden...
- BusyRunnable Berechnung: 149
- BusyRunnable Berechnung: 172
- BusyRunnable Berechnung: 196
- BusyRunnable Berechnung: 211
Abbruchzeit noch nicht erreicht:
    Abbruch nach: 20
    Bisher      : 8
Warte 2 Sekunden...
- BusyRunnable Berechnung: 224
- BusyRunnable Berechnung: 238
- BusyRunnable Berechnung: 241
- BusyRunnable Berechnung: 258
Abbruchzeit noch nicht erreicht:
    Abbruch nach: 20
    Bisher      : 10
Warte 2 Sekunden...
- BusyRunnable beendet
thread wurde während des letzten Wartens beendet.
NACH runner.runTask()
State : FINISHED_IN_TIME

*/