package de.duehl.twosidecommander.ui.list.element;

import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

/**
 * Diese Klasse stellt das Rechtsklick-Menü für die grafische Oberfläche eines Elements einer Liste
 * des Listen-Commanders dar, mit dem sich generisch zwischen zwei Listen von Dingen Listenelemente
 * kopieren, verschieben oder löschen lassen.
 *
 * @version 1.01     2025-06-13
 * @author Christian Dühl
 */

class ListElementPopupMenu extends JPopupMenu {

    private static final long serialVersionUID = 1L;


    /**
     * Konstruktor.
     *
     * @param showDetailsName
     *            Der Name des Menüpunkts zum Anzeigen von Details des Listenelements.
     * @param caller
     *            Wird aufgerufen, wenn der Benutzer im Popup-Menü auf Anzeigen der Details klickt.
     */
    public ListElementPopupMenu(String showDetailsName, DetailsCaller caller) {
        add(createShowDetailsItem(showDetailsName, caller));
    }


    private JMenuItem createShowDetailsItem(String showDetailsName, DetailsCaller caller) {
        JMenuItem menuItem = new JMenuItem(showDetailsName);
        menuItem.addActionListener(e -> caller.callDetailsDialog());
        return menuItem;
    }

}
