package de.duehl.twosidecommander.try1.element;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;

import de.duehl.swing.ui.dialogs.base.NonModalFrameDialogBase;
import de.duehl.twosidecommander.try1.element.displayer.DemoListElementDisplayer;
import de.duehl.twosidecommander.ui.list.data.ListElementMoveReactor;
import de.duehl.twosidecommander.ui.list.element.ListElementDisplayer;

public class Test1ListElementDisplayerFixMoveButtonsTester extends NonModalFrameDialogBase {

    private static final String TITLE = "ListElementDisplayer-Test";

    private static final Dimension DIALOG_DIMENSION = new Dimension(1000, 600);


    public Test1ListElementDisplayerFixMoveButtonsTester() {
        super(TITLE, DIALOG_DIMENSION);


        fillDialog();
    }

    @Override
    protected void populateDialog() {
        add(createListElementDisplayerPart(), BorderLayout.CENTER);
    }

    private Component createListElementDisplayerPart() {
        ListElementDisplayer displayer = new DemoListElementDisplayer(createListElementMoveReactor(),
                "Demo-Element");
        displayer.showMoveButtonsOnListElements(true);
        displayer.setListElementDisplayerClickReactor(
                aListElementDisplayer -> clickedOnListElement(aListElementDisplayer));

        return displayer.getPanel();
    }

    private ListElementMoveReactor createListElementMoveReactor() {
        return new ListElementMoveReactor() {
            @Override
            public boolean canListElementMoveUp(ListElementDisplayer displayer) {
                return true;
            }
            @Override
            public boolean canListElementMoveDown(ListElementDisplayer displayer) {
                return true;
            }
            @Override
            public void moveListElementToFirst(ListElementDisplayer displayer) {
                System.out.println("nach ganz oben");
            }
            @Override
            public void moveListElementUp(ListElementDisplayer displayer) {
                System.out.println("nach oben");
            }
            @Override
            public void moveListElementDown(ListElementDisplayer displayer) {
                System.out.println("nach unten");
            }
            @Override
            public void moveListElementToLast(ListElementDisplayer displayer) {
                System.out.println("nach ganz unten");
            }
        };
    }

    private void clickedOnListElement(ListElementDisplayer aListElementDisplayer) {
        DemoListElementDisplayer demoDiscplayer =
                DemoListElementDisplayer.castListElementDisplayer(aListElementDisplayer);
        String text = demoDiscplayer.getText();
        System.out.println("Links-Klick auf Element '" + text + "'!");
    }

    public static void main(String[] args) {
        Test1ListElementDisplayerFixMoveButtonsTester tester = new Test1ListElementDisplayerFixMoveButtonsTester();
        tester.setVisible(true);
    }

}
