package de.duehl.vocabulary.japanese.common.color.data;

import java.awt.Color;
import java.util.List;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.swing.ui.colors.ColorTool;

/**
 * Diese Klasse stellt die Standard-Farben zur Darstellung im den Vokabeltrainer bereit.
 *
 * Es gibt elf Farben, diese beziehen sich auf die elf Möglichkeiten, wie man die letzten zehn
 * Abfragen beantwortet haben kann:
 *
 *      1. Keine Abfrage richtig beantwortet, zehn Abfragen falsch beantwortet.
 *      2. Eine Abfrage richtig beantwortet, neun Abfragen falsch beantwortet.
 *      3. Zwei Abfragen richtig beantwortet, acht Abfragen falsch beantwortet.
 *      4. Drei Abfragen richtig beantwortet, sieben Abfragen falsch beantwortet.
 *      5. Vier Abfragen richtig beantwortet, sechs Abfragen falsch beantwortet.
 *      6. Fünf Abfragen richtig beantwortet, fünf Abfragen falsch beantwortet.
 *      7. Sechs Abfragen richtig beantwortet, vier Abfragen falsch beantwortet.
 *      8. Sieben Abfragen richtig beantwortet, drei Abfragen falsch beantwortet.
 *      9. Acht Abfragen richtig beantwortet, zwei Abfragen falsch beantwortet.
 *     10. Neun Abfragen richtig beantwortet, eine Abfrage falsch beantwortet.
 *     11. Zehn Abfragen richtig beantwortet, keine Abfrage falsch beantwortet.
 *
 * Die Farben gehen von rot (schlecht) über gelb (mittel) bis grün (gut).
 *
 * @version 1.01     2024-08-21
 * @author Christian Dühl
 */

public class DefaultColors {

    private static final List<String> SUBDUED_HEXCOLORS = CollectionsHelper.buildListFrom(
            "FF0000",
            "EE2200",
            "DD4400",
            "CC6600",
            "BB8800",
            "AAAA00",
            "88BB00",
            "66CC00",
            "44DD00",
            "22EE00",
            "00FF00"
            );

    private static final List<String> INTENSIVE_HEXCOLORS = CollectionsHelper.buildListFrom(
            "FF0000",
            "FF3300",
            "FF6600",
            "FF9900",
            "FFCC00",
            "FFFF00",
            "CCFF00",
            "99FF00",
            "66FF00",
            "33FF00",
            "00FF00"
            );

    public static final List<Color> SUBDUED_COLORS =
            ColorTool.hexColorListToJavaColorList(SUBDUED_HEXCOLORS);
    public static final List<Color> INTENSIVE_COLORS =
            ColorTool.hexColorListToJavaColorList(INTENSIVE_HEXCOLORS);

}
