package de.duehl.vocabulary.japanese.common.data;

/**
 * Diese Enum-Klasse steht für die Richtung, in die der Benutzer übersetzen will.
 *
 * @version 1.01     2024-03-25
 * @author Christian Dühl
 */

public enum TranslationDirection {

    JAPANESE_TO_GERMAN,
    GERMAN_TO_JAPANESE
    ;

    /** Ermittelt die Reihenfolge über den Namen. */
    public static TranslationDirection determineByName(String translationDirectionOrderName) {
        for (TranslationDirection sortOrder : TranslationDirection.values()) {
            String name = sortOrder.name();
            if (name.equals(translationDirectionOrderName)) {
                return sortOrder;
            }
        }

        throw new RuntimeException("Zum Namen '" + translationDirectionOrderName
                + "' konnte keine Reihenfolge der Übersetzung ermittelt werden.");
    }

}
