package de.duehl.vocabulary.japanese.common.tools;

import de.duehl.basics.io.FileHelper;
import de.duehl.basics.version.Version;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.common.persistence.SessionManager;

/**
 * Diese Klasse stellt Hilfsmethoden rund um den Pfad ver Vokabeln zur Verfügung.
 *
 * @version 1.01     2024-12-07
 * @author Christian Dühl
 */

public class VocabularyPathHelper {

    /** Lädt die Optionen von Klassen außerhalb des Vokabel-Trainers. */
    public static Options loadOptionsOutsideFromVocableTrainer() {
        SessionManager sessionManager = new SessionManager(createVersion000());
        Options options = sessionManager.load();
        return options;
    }

    /**
     * Erzeugt eine Version mit der Nummer 0.0.0 für die Verwendung des SesseionManagers oder der
     * Optionen von Klassen außerhalb des Vokabel-Trainers.
     */
    public static Version createVersion000() {
        return new Version( // Umbrüche wegen Ermittlung der Version des Projekts...
                "0.0.0",
                "interessiert nicht");
    }

    /**
     * Ermittelt das lokale Verzeichnis mit den Vokabeln über die Optionen des Vokabel-Trainers.
     */
    public static String determineLocalVocablesDirectory() {
        Options options = loadOptionsOutsideFromVocableTrainer();
        String path = options.getVocabulariesPath();
        if (!FileHelper.isDirectory(path)) {
            throw new RuntimeException("Das Verzeichnis der Vokabeln aus den Optionen des "
                    + "Vokabel-Trainers ist kein existierendes Verzeichnis.\n"
                    + "\t" + "path = " + path + "\n");
        }
        return path;
    }

}
