package de.duehl.vocabulary.japanese.logic.internal;

import java.util.Map;

import de.duehl.vocabulary.japanese.common.data.InternalAdditionalVocableData;
import de.duehl.vocabulary.japanese.data.Vocable;

/**
 * Diese Klasse kann zu einer Vokabel die internen, benutzerabhängigen Daten abrufen.
 *
 * @version 1.01     2024-08-21
 * @author Christian Dühl
 */

public class RealInternalDataRequester implements InternalDataRequester {

    /** Das Verzeichnis der internen Daten zu einer Vokabel nach der zugehörigen Variablen. */
    private final Map<Vocable, InternalAdditionalVocableData> vocable2InternalDataMap;

    /**
     * Konstruktor.
     *
     * @param vocable2InternalDataMap
     *            Das Verzeichnis der internen Daten zu einer Vokabel nach der zugehörigen
     *            Variablen.
     */
    public RealInternalDataRequester(
            Map<Vocable, InternalAdditionalVocableData> vocable2InternalDataMap) {
        this.vocable2InternalDataMap = vocable2InternalDataMap;
    }

    /**
     * Gibt die internen Daten zur übergebenen Vokabel zurück.
     *
     * Sind zu der Vokabel keine internen Daten hinterlegt, so wird eine Ausnahme geworfen.
     *
     * @param vocable
     *            Die Vokabel zu der man die internen Daten ermitteln möchte.
     * @return Die internen Daten zur übergebenen Vokabel
     */
    @Override
    public InternalAdditionalVocableData getInternalDataForVocable(Vocable vocable) {
        if (vocable2InternalDataMap.containsKey(vocable)) {
            return vocable2InternalDataMap.get(vocable);
        }
        else {
            throw new RuntimeException(""
                    + "Das Verzeichnis der internen Daten zu einer Vokabel nach der zugehörigen "
                    + "Variablen enthält keinen Eintrag für die übergebene Vokabel.\n"
                    + "\t" + "Vokabel: " + vocable);
        }
    }

}
