package de.duehl.vocabulary.japanese.logic.symbol.kana.test.data;

import de.duehl.vocabulary.japanese.data.symbol.Hiragana;

/**
 * Diese Klasse stellt das Ergebnis der Bewertung einer einzelnen Abfrage eines Hiragana dar
 *
 * @version 1.01     2025-02-02
 * @author Christian Dühl
 */

public class SingleUserInputHiraganaCheckResult {

    /** Das Hiragana welches abgefragt wurde. */
    private final Hiragana hiragana;

    /** Die Beschreibung der Fehler, fall welche gemacht wurden. */
    private String errorDescription;

    /** Gibt an, ob alles richtig ist. */
    private boolean ok;

    /** Konstruktor. */
    public SingleUserInputHiraganaCheckResult(Hiragana hiragana) {
        this.hiragana = hiragana;

        ok = true;
        errorDescription = "";
    }

    /** Getter für das Hiragana welches abgefragt wurde. */
    public Hiragana getHiragana() {
        return hiragana;
    }

    /** Getter für die Beschreibung der Fehler, fall welche gemacht wurden. */
    public String getErrorDescription() {
        return errorDescription;
    }

    /** Setter für die Beschreibung der Fehler, fall welche gemacht wurden. */
    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    /** Gibt an, ob alles richtig ist. */
    public boolean isOk() {
        return ok;
    }

    /** Legt fest, ob alles richtig ist. */
    public void setOk(boolean ok) {
        this.ok = ok;
    }

    @Override
    public String toString() {
        return "SingleUserInputHiraganaCheckResult [hiragana=" + hiragana + ", errorDescription="
                + errorDescription + ", ok=" + ok + "]";
    }

}
