package de.duehl.vocabulary.japanese.logic.symbol.kanji.internal;

import de.duehl.vocabulary.japanese.common.data.InternalAdditionalKanjiData;
import de.duehl.vocabulary.japanese.data.symbol.Kanji;

/**
 * Dieses Interface steht für ein Objekt, das zu einem Kanji die internen, benutzerabhängigen
 * Daten abrufen kann.
 *
 * @version 1.01     2024-11-07
 * @author Christian Dühl
 */

public interface InternalKanjiDataRequester {

    /**
     * Gibt die internen Daten zum übergebenen Kanji zurück.
     *
     * Sind zu der Kanji keine internen Daten hinterlegt, so wird eine Ausnahme geworfen.
     *
     * @param kanji
     *            Die Kanji zu der man die internen Daten ermitteln möchte.
     * @return Die internen Daten zur übergebenen Kanji.
     */
    InternalAdditionalKanjiData getInternalDataForKanji(Kanji kanji);

}
