package de.duehl.vocabulary.japanese.startup.logic.steps;

import java.util.List;
import java.util.Map;

import de.duehl.basics.datetime.time.watch.StopWatch;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.data.Vocabulary;
import de.duehl.vocabulary.japanese.logic.internal.InternalDataRequester;
import de.duehl.vocabulary.japanese.logic.wrongtested.WrongTestedVocables;
import de.duehl.vocabulary.japanese.startup.ui.data.SplashScreenable;

/**
 * Diese Klasse steht für den Schritt der die falsch übersetzten Vokabeln einliest.
 *
 * @version 1.01     2025-11-23
 * @author Christian Dühl
 */

public class Step10ReadWrongTestedVocableLists extends StartupStep {

    /** Die Liste mit den bekannten Vokabularien. */
    private final List<Vocabulary> vocabularies;

    /** Das Objekt das zu Vokabeln die internen Daten abfragt. */
    private final InternalDataRequester internalDataRequester;

    /** Das Verzeichnis der Vokabeln nach ihrem Schlüssel. */
    private final Map<String, Vocable> keyToVocable;

    /**
     * Die Verwaltung der beiden automatisch gepflegten Listen mit falsch abgefragten Vokabeln aus
     * Gruppen und anderen Vokabularien.
     */
    private WrongTestedVocables wrongTestedVocables;

    /**
     * Konstruktor.
     *
     * @param step
     *            Der Schritt der durchgeführt wird.
     * @param options
     *            Die Programmoptionen.
     * @param splashScreen
     *            Die grafische Oberfläche beim Start in der die Meldungen angezeigt werden.
     * @param watch
     *            Misst die Laufzeit des gesamten Startups.
     * @param vocabularies
     *            Die Liste mit den bekannten Vokabularien.
     * @param internalDataRequester
     *            Das Objekt das zu Vokabeln die internen Daten abfragt.
     * @param keyToVocable
     *            Das Verzeichnis der Vokabeln nach ihrem Schlüssel.
     */
    public Step10ReadWrongTestedVocableLists(String step, Options options,
            SplashScreenable splashScreen, StopWatch watch, List<Vocabulary> vocabularies,
            InternalDataRequester internalDataRequester, Map<String, Vocable> keyToVocable) {
        super(step, options, splashScreen, watch);
        this.vocabularies = vocabularies;
        this.internalDataRequester = internalDataRequester;
        this.keyToVocable = keyToVocable;
    }

    /** Führt den eigentlichen Inhalt des Schritts aus. */
    @Override
    protected void runInternalStep() {
        appendMessage("Erzeuge Verwaltung der automatisch gepflegten Listen der falsch übersetzten "
                + "Vokabeln ...");
        wrongTestedVocables = new WrongTestedVocables(vocabularies, keyToVocable,
                internalDataRequester);
    }

    /**
     * Getter für die Verwaltung der beiden automatisch gepflegten Listen mit falsch abgefragten
     * Vokabeln aus Gruppen und anderen Vokabularien.
     */
    public WrongTestedVocables getWrongTestedVocables() {
        return wrongTestedVocables;
    }

}
