package de.duehl.vocabulary.japanese.ui.components.data;

/**
 * Dieses Interface steht für eine Klasse, welche auf die Eingabe einer Übersetzung durch den
 * Benutzer reagiert.
 *
 * @version 1.01     2024-06-13
 * @author Christian Dühl
 */

public interface VocableTestReactor {


    /**
     * Wird aufgerufen, wenn der Benutzer eine Übersetzung eines japanischen Begriffs eingegeben
     * hat.
     *
     * @param kana
     *            Die Darstellung in Kana der Vokabel welche abgefragt wird.
     * @param kanji
     *            Die Darstellung in Kanji der Vokabel welche abgefragt wird.
     * @param translationByUser
     *            Die vom Benutzer eingegebene Übersetzung.
     */
    void userEnteredJapaneseToGermanTranslation(String kana, String kanji,
            String translationByUser);

    /**
     * Wird aufgerufen, wenn der Benutzer eine Übersetzung eines japanischen Begriffs eingegeben
     * hat.
     *
     * @param germanTerm
     *            Der abgefragte deutsche Begriff.
     * @param translationByUser
     *            Die vom Benutzer eingegebene Übersetzung.
     */
    void userEnteredGermanToJapaneseTranslation(String germanTerm, String translationByUser);

    /** Schaltet zur nächsten Variablen weiter. */
    void switchToNextVocable();

    /** Gibt an, ob eine leere Übersetzung ausgewertet werden soll. */
    boolean doWeHaveToReactOnEmptyTranslation();

}
