package de.duehl.vocabulary.japanese.ui.creation.menu;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

import javax.swing.JMenu;
import javax.swing.JMenuItem;

import de.duehl.swing.ui.menu.MyMenuItem;
import de.duehl.swing.ui.menu.SingleMenuCreation;
import de.duehl.vocabulary.japanese.ui.VocabularyTrainerGui;

/**
 * Diese Klasse erzeugt das Grammatik-Menü der graphischen Oberfläche des Vokabel-Trainers.
 *
 * @version 1.01     2025-11-30
 * @author Christian Dühl
 */

public class GrammarMenuCreation implements SingleMenuCreation {

    /** Verbindung zur grafischen Oberfläche. */
    private final VocabularyTrainerGui gui;

    /**
     * Konstruktor.
     *
     * @param gui
     *            Verbindung zur grafischen Oberfläche.
     */
    public GrammarMenuCreation(VocabularyTrainerGui gui) {
        this.gui = gui;
    }

    /** Erzeugt das Grammatik-Menü. */
    @Override
    public JMenu createTheMenu() {
        JMenu menu = new JMenu("Grammatik");
        menu.setMnemonic('g');

        menu.add(createShowVerbsInWoerterbuchformAsListMenuItem());
        menu.add(createShowAdjectivesInPositivePresenceAsListMenuItem());
        menu.add(createShowIAdjectivesInPositivePresenceAsListMenuItem());
        menu.add(createShowNaAdjectivesInPositivePresenceAsListMenuItem());

        menu.addSeparator();

        menu.add(createShowListOfNaAdjectivesEndingWithIMenuItem());
        menu.add(createShowListOfIruEruExceptionVerbsMenuItem());

        menu.addSeparator();

        menu.add(createCreateVerbOrAdjectiveTablesMenuItem());

        return menu;
    }

    private JMenuItem createShowVerbsInWoerterbuchformAsListMenuItem() {
        return new MyMenuItem("Verben in Wörterbuchform als Liste anzeigen ...")
                .mnemonic('v')
                .accelerator(KeyEvent.VK_W, InputEvent.CTRL_DOWN_MASK)
                .actionListener(e -> gui.showVerbsInWoerterbuchformAsList());
    }

    private JMenuItem createShowAdjectivesInPositivePresenceAsListMenuItem() {
        return new MyMenuItem("Adjektive in Grundform (positive Gegenwart) als Liste anzeigen ...")
                .mnemonic('a')
                .accelerator(KeyEvent.VK_G, InputEvent.CTRL_DOWN_MASK)
                .actionListener(e -> gui.showAdjectivesInPositivePresenceAsList());
    }

    private JMenuItem createShowIAdjectivesInPositivePresenceAsListMenuItem() {
        return new MyMenuItem(
                "い-Adjektive in Grundform (positive Gegenwart) als Liste anzeigen ...")
                        //.mnemonic('a')
                //.accelerator(KeyEvent.VK_G, InputEvent.CTRL_DOWN_MASK)
                .actionListener(e -> gui.showIAdjectivesInPositivePresenceAsList());
    }

    private JMenuItem createShowNaAdjectivesInPositivePresenceAsListMenuItem() {
        return new MyMenuItem(
                "な-Adjektive in Grundform (positive Gegenwart) als Liste anzeigen ...")
                        //.mnemonic('a')
                //.accelerator(KeyEvent.VK_G, InputEvent.CTRL_DOWN_MASK)
                .actionListener(e -> gui.showNaAdjectivesInPositivePresenceAsList());
    }

    private JMenuItem createShowListOfNaAdjectivesEndingWithIMenuItem() {
        return new MyMenuItem("な-Adjektive die auf い enden als Liste anzeigen ...")
                .mnemonic('n')
                //.accelerator(KeyEvent.VK_W, InputEvent.CTRL_DOWN_MASK)
                .actionListener(e -> gui.showListOfNaAdjectivesEndingWithI());
    }

    private JMenuItem createShowListOfIruEruExceptionVerbsMenuItem() {
        return new MyMenuItem("いる/える-Ausnahme-Verben als Liste anzeigen ...")
                .mnemonic('i')
                //.accelerator(KeyEvent.VK_W, InputEvent.CTRL_DOWN_MASK)
                .actionListener(e -> gui.showListOfIruEruExceptionVerbs());
    }

    private JMenuItem createCreateVerbOrAdjectiveTablesMenuItem() {
        return new MyMenuItem("Grammatikalische Tabellen von Verben oder Adjektiven erstellen ...")
                .mnemonic('t')
                .accelerator(KeyEvent.VK_T, InputEvent.CTRL_DOWN_MASK)
                .actionListener(e -> gui.createVerbOrAdjectiveTables());
    }

}
