package de.duehl.vocabulary.japanese.ui.creation.menu;

import java.awt.event.KeyEvent;

import javax.swing.JMenu;
import javax.swing.JMenuItem;

import de.duehl.swing.ui.menu.MyMenuItem;
import de.duehl.swing.ui.menu.SingleMenuCreation;
import de.duehl.vocabulary.japanese.ui.VocabularyTrainerGui;

/**
 * Diese Klasse erzeugt das Hilfe-Menü der graphischen Oberfläche des Vokabel-Trainers.
 *
 * @version 1.01     2024-03-20
 * @author Christian Dühl
 */

public class HelpMenuCreation implements SingleMenuCreation {

    /** Verbindung zur grafischen Oberfläche. */
    private final VocabularyTrainerGui gui;

    /**
     * Konstruktor.
     *
     * @param gui
     *            Verbindung zur grafischen Oberfläche.
     */
    public HelpMenuCreation(VocabularyTrainerGui gui) {
        this.gui = gui;
    }

    /** Erzeugt das Hilfe-Menü. */
    @Override
    public JMenu createTheMenu() {
        JMenu menu = new JMenu("Hilfe");
        menu.setMnemonic('h');

        menu.add(createAboutMenuItem());

        menu.addSeparator();

        menu.add(createHelpMenuItem());

        menu.addSeparator();

        menu.add(createTodoMenuItem());
        menu.add(createChangesMenuItem());

        menu.addSeparator();

        menu.add(createKeyboardCommandsDescriptionMenuItem());
        menu.add(createKeyboardCommandsDescriptionSortMenuItem());

        return menu;
    }

    private JMenuItem createAboutMenuItem() {
        return new MyMenuItem("Über das Programm ...")
                .mnemonic('ü')
                .actionListener(e -> gui.about());
    }

    private JMenuItem createHelpMenuItem() {
        return new MyMenuItem("Hilfe")
                .mnemonic('h')
                .accelerator(KeyEvent.VK_F1, 0)
                .actionListener(e -> gui.help());
    }

    private JMenuItem createTodoMenuItem() {
        return new MyMenuItem("Weiterentwicklung (todo)")
                .mnemonic('w')
                .actionListener(e -> gui.todo());
    }

    private JMenuItem createChangesMenuItem() {
        return new MyMenuItem("Neuigkeiten / Änderungen")
                .mnemonic('n')
                .actionListener(e -> gui.changes());
    }

    private JMenuItem createKeyboardCommandsDescriptionMenuItem() {
        return new MyMenuItem("Tastaturbelegung in Menüreihenfolge")
                .mnemonic('b')
                .actionListener(e -> gui.keyboardDescription());
    }

    private JMenuItem createKeyboardCommandsDescriptionSortMenuItem() {
        return new MyMenuItem("Tastaturbelegung in der Reihenfolge der Tasten")
                .mnemonic('r')
                .actionListener(e -> gui.keyboardDescriptionSortByKeys());
    }

}
