package de.duehl.vocabulary.japanese.ui.creation.menu;

//import java.awt.event.InputEvent;
//import java.awt.event.KeyEvent;

import javax.swing.JMenu;
import javax.swing.JMenuItem;

import de.duehl.swing.ui.menu.MyMenuItem;
import de.duehl.swing.ui.menu.SingleMenuCreation;
import de.duehl.vocabulary.japanese.logic.VocabularyTrainerLogic;

/**
 * Diese Klasse erzeugt das Update-Menü der graphischen Oberfläche des Vokabel-Trainers.
 *
 * @version 1.01     2024-12-11
 * @author Christian Dühl
 */

public class UpdateMenuCreation implements SingleMenuCreation {

    /** Verbindung zur Logik des Editors. */
    private final VocabularyTrainerLogic logic;

    /**
     * Konstruktor.
     *
     * @param logic
     *            Verbindung zur Logik.
     */
    public UpdateMenuCreation(VocabularyTrainerLogic logic) {
        this.logic = logic;
    }

    /** Erzeugt das Datei-Menü. */
    @Override
    public JMenu createTheMenu() {
        JMenu menu = new JMenu("Update");
        menu.setMnemonic('u');

        //menu.addSeparator();

        menu.add(createCheckNewProgramVersionMenuItem());
        menu.add(createCheckNewVocabulariesVersionMenuItem());
        menu.add(createCheckNewOwnListsVersionMenuItem());

        return menu;
    }

    private JMenuItem createCheckNewProgramVersionMenuItem() {
        return new MyMenuItem("Auf eine aktuellere Version des Programms prüfen ...")
                .mnemonic('p')
                //.accelerator(KeyEvent.VK_F4, InputEvent.ALT_DOWN_MASK)
                .actionListener(e -> logic.checkNewProgramVersion());
    }

    private JMenuItem createCheckNewVocabulariesVersionMenuItem() {
        return new MyMenuItem("Auf eine aktuellere Version der Vokabularien prüfen ...")
                .mnemonic('v')
                //.accelerator(KeyEvent.VK_F4, InputEvent.ALT_DOWN_MASK)
                .actionListener(e -> logic.checkNewVocabulariesVersion());
    }

    private JMenuItem createCheckNewOwnListsVersionMenuItem() {
        return new MyMenuItem("Auf eine aktuellere Version der eigenen Listen prüfen ...")
                .mnemonic('l')
                //.accelerator(KeyEvent.VK_F4, InputEvent.ALT_DOWN_MASK)
                .actionListener(e -> logic.checkNewOwnListsVersion());
    }

}
