package de.duehl.vocabulary.japanese.ui.creation.menu;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

import javax.swing.JMenu;
import javax.swing.JMenuItem;

import de.duehl.swing.ui.menu.MyMenuItem;
import de.duehl.swing.ui.menu.SingleMenuCreation;
import de.duehl.vocabulary.japanese.ui.VocabularyTrainerGui;

/**
 * Diese Klasse erzeugt das Vokabel-Menü der graphischen Oberfläche des Vokabel-Trainers.
 *
 * @version 1.01     2024-10-26
 * @author Christian Dühl
 */

public class VocableMenuCreation implements SingleMenuCreation {

    /** Verbindung zur grafischen Oberfläche. */
    private final VocabularyTrainerGui gui;

    /**
     * Konstruktor.
     *
     * @param gui
     *            Verbindung zur grafischen Oberfläche.
     */
    public VocableMenuCreation(VocabularyTrainerGui gui) {
        this.gui = gui;
    }

    /** Erzeugt das Vokabeln-Menü. */
    @Override
    public JMenu createTheMenu() {
        JMenu menu = new JMenu("Vokabeln");
        menu.setMnemonic('v');

        menu.add(createSearchVocablesMenuItem());
        menu.add(createComplexSearchVocablesMenuItem());

        menu.addSeparator();

        menu.add(createShowAllVocablesWithASpecificSearchWordMenuItem());
        menu.add(createShowAllVocablesWithASpecificPartOfSpeachMenuItem());

        menu.addSeparator();

        menu.add(createShowAllVocablesAsListMenuItem());
        menu.add(createShowAllVocablesAsSheetMenuItem());
        menu.add(createTestAllVocablesMenuItem());

        menu.addSeparator();

        menu.add(createSelectAllVocabulariesOnViewedTabMenuItem());
        menu.add(createDeselectAllVocabulariesOnViewedTabMenuItem());
        menu.add(createShowSelectedVocabulariesOnViewedTabMenuItem());
        menu.add(createTest10RandomVocablesFromSelectedVocabulariesOnViewedTabMenuItem());
        menu.add(createTestSelectedVocabulariesOnViewedTabMenuItem());

        menu.addSeparator();

        menu.add(createTest10RandomVocablesMenuItem());

        menu.addSeparator();

        menu.add(createShowNotTestedVocablesMenuItem());
        menu.add(createShowNotTestedVocablesAsSheetMenuItem());
        menu.add(createShowNotTestedVocablesAsListMenuItem());
        menu.add(createTestNotTestedVocablesMenuItem());

        menu.addSeparator();

        menu.add(createShowNotCorrectTestedVocablesMenuItem());
        menu.add(createTestNotCorrectTestedVocablesMenuItem());

        menu.addSeparator();

        menu.add(createShowNotTestedForAWhileVocablesMenuItem());
        menu.add(createTestNotTestedForAWhileVocablesMenuItem());

        menu.addSeparator();

        menu.add(createShowNotCorrectTestedForAWhileVocablesMenuItem());
        menu.add(createTestNotCorrectTestedForAWhileVocablesMenuItem());

        menu.addSeparator();

        menu.add(createShowNewestVocablesMenuItem());
        menu.add(createShowNewestVocablesAsSheetMenuItem());
        menu.add(createShowNewestVocablesAsListMenuItem());
        menu.add(createTestNewestVocablesMenuItem());

        return menu;
    }

    private JMenuItem createSearchVocablesMenuItem() {
        return new MyMenuItem("Vokabeln suchen (einfach) ...")
                .mnemonic('s')
                .accelerator(KeyEvent.VK_F, InputEvent.CTRL_DOWN_MASK)
                .actionListener(e -> gui.vocableSearch());
    }

    private JMenuItem createComplexSearchVocablesMenuItem() {
        return new MyMenuItem("Vokabeln suchen (erweitert) ...")
                .mnemonic('e')
                .accelerator(KeyEvent.VK_F, InputEvent.CTRL_DOWN_MASK | InputEvent.SHIFT_DOWN_MASK)
                .actionListener(e -> gui.complexVocableSearch());
    }

    private JMenuItem createShowAllVocablesWithASpecificSearchWordMenuItem() {
        return new MyMenuItem("Alle Vokabeln mit einem bestimmten Suchbegriff anzeigen ...")
                .accelerator(KeyEvent.VK_F6, 0)
                .actionListener(e -> gui.showAllVocablesWithASpecificSearchWord());
    }

    private JMenuItem createShowAllVocablesWithASpecificPartOfSpeachMenuItem() {
        return new MyMenuItem("Alle Vokabeln mit einer bestimmten Wortart anzeigen ...")
                .accelerator(KeyEvent.VK_F7, 0)
                .actionListener(e -> gui.showAllAllVocablesWithASpecificPartOfSpeach());
    }

    private JMenuItem createShowAllVocablesAsListMenuItem() {
        return new MyMenuItem("Alle Vokabeln als Liste anzeigen ...")
                //.accelerator(KeyEvent.VK_F6, 0)
                .actionListener(e -> gui.showAllVocablesAsList());
    }

    private JMenuItem createShowAllVocablesAsSheetMenuItem() {
        return new MyMenuItem("Alle Vokabeln als Blatt anzeigen ...")
                //.accelerator(KeyEvent.VK_F7, 0)
                .actionListener(e -> gui.showAllVocablesAsSheet());
    }

    private JMenuItem createTestAllVocablesMenuItem() {
        return new MyMenuItem("Alle Vokabeln abfragen ...")
                //.accelerator(KeyEvent.VK_F8, 0)
                .actionListener(e -> gui.testAllVocabularies());
    }

    private JMenuItem createSelectAllVocabulariesOnViewedTabMenuItem() {
        return new MyMenuItem("Alle Vokabularien im aktuellen Reiter auswählen")
                //.accelerator(KeyEvent.VK_F8, 0)
                .actionListener(e -> gui.selectAllVocabulariesInTab());
    }

    private JMenuItem createDeselectAllVocabulariesOnViewedTabMenuItem() {
        return new MyMenuItem("Alle Vokabularien im aktuellen Reiter abwählen")
                //.accelerator(KeyEvent.VK_F8, 0)
                .actionListener(e -> gui.deselectAllVocabulariesInTab());
    }

    private JMenuItem createShowSelectedVocabulariesOnViewedTabMenuItem() {
        return new MyMenuItem("Alle Vokabeln der ausgewählten Vokabularien anzeigen ...")
                //.accelerator(KeyEvent.VK_F8, 0)
                .actionListener(e -> gui.listSelectedVocabularies());
    }

    private JMenuItem createTest10RandomVocablesFromSelectedVocabulariesOnViewedTabMenuItem() {
        return new MyMenuItem("Zehn zufällige Vokabeln der ausgewählten Vokabularien anzeigen ...")
                //.accelerator(KeyEvent.VK_F8, 0)
                .actionListener(e -> gui.test10RandomVocablesFromSelectedVocabularies());
    }

    private JMenuItem createTestSelectedVocabulariesOnViewedTabMenuItem() {
        return new MyMenuItem("Alle Vokabeln der ausgewählten Vokabularien abfragen ...")
                //.accelerator(KeyEvent.VK_F8, 0)
                .actionListener(e -> gui.testSelectedVocabularies());
    }

    private JMenuItem createTest10RandomVocablesMenuItem() {
        return new MyMenuItem("Zehn zufällige Vokabeln abfragen ...")
                .accelerator(KeyEvent.VK_F8, 0)
                .actionListener(e -> gui.test10RandomVocables());
    }

    private JMenuItem createShowNotTestedVocablesMenuItem() {
        return new MyMenuItem("Noch nicht abgefragte Vokabeln anzeigen ...")
                .mnemonic('z')
                //.accelerator(KeyEvent.VK_U, InputEvent.CTRL_DOWN_MASK)
                .actionListener(e -> gui.showNotTestedVocables());
    }

    private JMenuItem createShowNotTestedVocablesAsSheetMenuItem() {
        return new MyMenuItem("Noch nicht abgefragte Vokabeln als Blatt anzeigen ...")
                .mnemonic('z')
                //.accelerator(KeyEvent.VK_F5, 0)
                .actionListener(e -> gui.showNotTestedVocablesAsSheet());
    }

    private JMenuItem createShowNotTestedVocablesAsListMenuItem() {
        return new MyMenuItem("Noch nicht abgefragte Vokabeln als Liste anzeigen ...")
                .mnemonic('z')
                //.accelerator(KeyEvent.VK_F5, 0)
                .actionListener(e -> gui.showNotTestedVocablesAsList());
    }

    private JMenuItem createTestNotTestedVocablesMenuItem() {
        return new MyMenuItem("Noch nicht abgefragte Vokabeln abfragen")
                .mnemonic('n')
                .accelerator(KeyEvent.VK_U, InputEvent.CTRL_DOWN_MASK)
                .actionListener(e -> gui.testNotTestedVocables());
    }

    private JMenuItem createShowNotCorrectTestedVocablesMenuItem() {
        return new MyMenuItem("Noch nicht korrekt übersetzte Vokabeln anzeigen")
                //.mnemonic('z')
                //.accelerator(KeyEvent.VK_F5, 0)
                .actionListener(e -> gui.showNotCorrectTestedVocables());
    }

    private JMenuItem createTestNotCorrectTestedVocablesMenuItem() {
        return new MyMenuItem("Noch nicht korrekt übersetzte Vokabeln abfragen")
                //.mnemonic('n')
                //.accelerator(KeyEvent.VK_F5, 0)
                .actionListener(e -> gui.testNotCorrectTestedVocables());
    }

    private JMenuItem createShowNotTestedForAWhileVocablesMenuItem() {
        return new MyMenuItem("Lange nicht mehr abgefragte Vokabeln anzeigen")
                //.mnemonic('z')
                //.accelerator(KeyEvent.VK_F5, 0)
                .actionListener(e -> gui.showNotTestedForAWhileVocables());
    }

    private JMenuItem createTestNotTestedForAWhileVocablesMenuItem() {
        return new MyMenuItem("Lange nicht mehr abgefragte Vokabeln abfragen")
                //.mnemonic('n')
                //.accelerator(KeyEvent.VK_F5, 0)
                .actionListener(e -> gui.testNotTestedForAWhileVocables());
    }

    private JMenuItem createShowNotCorrectTestedForAWhileVocablesMenuItem() {
        return new MyMenuItem("Lange nicht mehr korrekt übersetzte Vokabeln anzeigen")
                //.mnemonic('z')
                //.accelerator(KeyEvent.VK_F5, 0)
                .actionListener(e -> gui.showNotCorrectTestedForAWhileVocables());
    }

    private JMenuItem createTestNotCorrectTestedForAWhileVocablesMenuItem() {
        return new MyMenuItem("Lange nicht mehr korrekt übersetzte Vokabeln abfragen")
                //.mnemonic('n')
                //.accelerator(KeyEvent.VK_F5, 0)
                .actionListener(e -> gui.testNotCorrectTestedForAWhileVocables());
    }

    private JMenuItem createShowNewestVocablesMenuItem() {
        return new MyMenuItem("Neuste Vokabeln anzeigen")
                //.mnemonic('z')
                //.accelerator(KeyEvent.VK_F5, 0)
                .actionListener(e -> gui.showNewestVocables());
    }

    private JMenuItem createShowNewestVocablesAsSheetMenuItem() {
        return new MyMenuItem("Neuste Vokabeln als Blatt anzeigen ...")
                .mnemonic('z')
                //.accelerator(KeyEvent.VK_F5, 0)
                .actionListener(e -> gui.showNewestVocablesAsSheet());
    }

    private JMenuItem createShowNewestVocablesAsListMenuItem() {
        return new MyMenuItem("Neuste Vokabeln als Liste anzeigen ...")
                .mnemonic('z')
                //.accelerator(KeyEvent.VK_F5, 0)
                .actionListener(e -> gui.showNewestVocablesAsList());
    }

    private JMenuItem createTestNewestVocablesMenuItem() {
        return new MyMenuItem("Neuste Vokabeln abfragen")
                //.mnemonic('n')
                //.accelerator(KeyEvent.VK_F5, 0)
                .actionListener(e -> gui.testNewestVocables());
    }

}
