package de.duehl.vocabulary.japanese.ui.dialog.grammar.subdialogs.data;

import javax.swing.JCheckBox;

import de.duehl.vocabulary.japanese.data.Vocable;

/**
 * Diese Klasse stellt eine Grundform eines Verbs oder Adjektivs zusammen mit der zugehörigen
 * CheckBox dar.
 *
 * @version 1.01     2025-11-27
 * @author Christian Dühl
 */

public class BaseFormAndCheckBox {

    /** Die Vokabel in Grundform eines Verbs oder Adjektivs. */
    private final Vocable baseFormVocable;

    /** Die zugehörige CheckBox. */
    private final JCheckBox checkBox;

    /**
     * Konstruktor.
     *
     * @param baseForm
     *            Die Grundform eines Verbs oder Adjektivs.
     * @param checkBox
     *            Die zugehörige CheckBox.
     */
    public BaseFormAndCheckBox(Vocable baseFormVocable, JCheckBox checkBox) {
        this.baseFormVocable = baseFormVocable;
        this.checkBox = checkBox;
    }

    /** Getter für Vokabel in Grundform eines Verbs oder Adjektivs. */
    public Vocable getBaseFormVocable() {
        return baseFormVocable;
    }

    /** Getter für die zugehörige CheckBox. */
    public JCheckBox getCheckBox() {
        return checkBox;
    }

}
