package de.duehl.vocabulary.japanese.ui.dialog.kana.hiraganatest.components;

import java.awt.Color;

import javax.swing.JLabel;

import de.duehl.swing.ui.GuiTools;
import de.duehl.vocabulary.japanese.data.symbol.Hiragana;

/**
 * Diese Klasse stellt ein einzelnes Hiragana-Zeichen (UTF-8) in einem Label dar.
 *
 * @version 1.01     2025-02-02
 * @author Christian Dühl
 */

public class HiraganaLabel {

    private static final int DEFAULT_BIGGER_FONT_SIZE = 400;


    /** Die Vergrößerung der Schrift in der das Hiragana dargestellt wird. */
    private int biggerFontSize;

    /** Das Label auf dem das Hiragana dargestellt wird. */
    private final JLabel label;

    /** Gibt an, ob die Größe schon gesetzt wurde. */
    private boolean sizeSet;

    /** Konstruktor. */
    public HiraganaLabel() {
        biggerFontSize = DEFAULT_BIGGER_FONT_SIZE;

        label = new JLabel();
        sizeSet = false;

        initLabel();
    }

    private void initLabel() {
        label.setOpaque(true);
        label.setBackground(Color.WHITE);
        label.setHorizontalAlignment(JLabel.CENTER);
        label.setVerticalAlignment(JLabel.CENTER);
    }

    /** Setter für die Vergrößerung der Schrift in der das Hiragana dargestellt wird. */
    public void setBiggerFontSize(int biggerFontSize) {
        this.biggerFontSize = biggerFontSize;
    }

    /** Zeigt das Hiragana an. Kann mehrfach aufgerufen werden. */
    public void showHiragana(Hiragana hiragana) {
        setSizeIfNecessary();

        String hiraganaCharacter = hiragana.getCharacter();
        label.setText(hiraganaCharacter);
    }

    private void setSizeIfNecessary() {
        if (!sizeSet) {
            GuiTools.biggerFont(label, biggerFontSize);
            sizeSet = true;
        }
    }

    /** Getter für das Label auf dem das Hiragana dargestellt wird. */
    public JLabel getLabel() {
        return label;
    }

}
