package de.duehl.vocabulary.japanese.ui.dialog.table;

import static de.duehl.vocabulary.japanese.common.data.InternalAdditionalVocableData.NOT_SEEN_DATE;

import de.duehl.basics.datetime.date.ImmutualDate;

/**
 * Diese Klasse enthält Hilfsmethoden rund um Tabellen.
 *
 * @version 1.01     2024-11-07
 * @author Christian Dühl
 */

public class TableHelper {

    /** Setzt den übergebenen Text in HTML mit Monospace-Font. */
    public static String createMonospaceHtml(String text) {
        return ""
                + "<html><span style=\"font-family:monospace\">"
                + text
                + "</span></html>";
    }

    /** Gibt bei testCount < 1 oder dem NOT-SEEN-DATE null zurück, ansonsten das übergebene Datum. */
    public static ImmutualDate dateOrEmpty(ImmutualDate date, int testCount) {
        if (testCount < 1 || NOT_SEEN_DATE.equals(date)) {
            return null;
        }
        else {
            return date;
        }
    }

}
