package de.duehl.vocabulary.japanese.ui.dialog.vocables.detail.findlists;

import java.awt.Component;

import javax.swing.JPanel;

import de.duehl.swing.ui.layout.VerticalLayout;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.Vocable;

/**
 * Diese Klasse stellt einen Button bereit, um zu einer veränderlichen Vokabel alle eigenen Listen
 * zu finden und anzuzeigen, die diese Vokabel enthalten.
 *
 * @version 1.01     2025-11-21
 * @author Christian Dühl
 */

public class ListsWithVocableFinderWithChangingVocableGui {

    /** Findet zu einer Vokabel alle Listen, die diese Vokabel enthalten. */
    private final ListsWithVocableFinder listsWithVocableFinder;

    /** Der Panel mit dem Button. */
    private final JPanel buttonPanel;

    /**
     * Konstruktor.
     *
     * @param dataStructures
     *            Die Datenstrukturen des Vokabeltrainers.
     * @param thisPanelUsingDialog
     *            Der modale oder nicht modale Dialog bzw., Frame, der den Panel nutzt, welcher
     *            diese Klasse verwendet.
     */
    public ListsWithVocableFinderWithChangingVocableGui(FumikoDataStructures dataStructures,
            Component thisPanelUsingDialog) {
        listsWithVocableFinder = new ListsWithVocableFinder(dataStructures, thisPanelUsingDialog);


        buttonPanel = new JPanel();
        buttonPanel.setLayout(new VerticalLayout(0, VerticalLayout.BOTH));
    }

    /**
     * Fügt zum übergebenen Panel einen Button zur Anzeige der eigenen Listen an, welche die
     * Vokabel enthalten.
     *
     * @param panel
     *            Der Panel dem der Button hinzugefügt werden sollen. Dieser sollte ein Layout
     *            haben, das das Hinzufügen von Elemente ohne weitere Parameter gestattet, wie z.B.
     *            das VerticalLayout.
     */
    public void appendButtonToPanel(JPanel panel) {
        panel.add(buttonPanel);
    }

    /** Setter für die Vokabel. */
    public void setVocable(Vocable vocable) {
        updateButtonPanel(vocable);
    }

    private void updateButtonPanel(Vocable vocable) {
        ListsWithVocableFinderButtonCreator creator = new ListsWithVocableFinderButtonCreator(
                vocable, listsWithVocableFinder);

        buttonPanel.removeAll();
        buttonPanel.add(creator.createFindListsWithVocableButton());
    }

}
