package de.duehl.vocabulary.japanese.website.update.ownlists;

import java.util.ArrayList;
import java.util.List;

import javax.swing.SwingUtilities;

import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.ui.data.FumikoUiObjects;
import de.duehl.vocabulary.japanese.website.download.NewestOwnListVersionListDownloader;
import de.duehl.vocabulary.japanese.website.update.ownlists.data.NewestOwnListVersionListEntry;
import de.duehl.vocabulary.japanese.website.update.ownlists.data.OwnListInterestAndVersionEntry;
import de.duehl.vocabulary.japanese.website.update.ownlists.interest.OwnListVersionAndInterestIo;

import static de.duehl.vocabulary.japanese.common.website.update.UpdateTools.informUserAboutDownloadFailure;

/**
 * Diese Klasse erlaubt unabhängig von der Prüfung auf Neuerungen (vgl. Klasse
 * OwnListGroupsUpdater) den Download von Gruppen von eigenen Listen von der Webseite.
 *
 * @version 1.01     2025-11-20
 * @author Christian Dühl
 */

public class GroupsOfOwnListsFromWebsiteImporter {

    /** Die Datenstrukturen des Vokabeltrainers. */
    private final FumikoDataStructures dataStructures;

    /** Die häufig verwendeten Funktionen der grafischen Oberfläche des Vokabeltrainers. */
    private final FumikoUiObjects uiObjects;

    /** Die Liste der Einträge in der Datei Neuste_Version_Listen.txt auf dem Server. */
    private List<NewestOwnListVersionListEntry> newestOwnListVersionEntries;

    /**
     * Die Liste der Einträge in der Datei Eigene_Listen_Interessen_und_Versionen.txt auf dem
     * Rechner des Benutzers.
     */
    private List<OwnListInterestAndVersionEntry> interestAndVersionEntries;

    /**
     * Die Liste derjenigen Gruppennamen, die der Benutzer bisher noch nicht oder nur in einer
     * älteren Version kannte.
     */
    private List<String> newerOrUnseenGroupNames;

    /**
     * Konstruktor.
     *
     * @param dataStructures
     *            Die Datenstrukturen des Vokabeltrainers.
     * @param uiObjects
     *            Die häufig verwendeten Funktionen der grafischen Oberfläche des Vokabeltrainers.
     */
    public GroupsOfOwnListsFromWebsiteImporter(FumikoDataStructures dataStructures,
            FumikoUiObjects uiObjects) {
        this.dataStructures = dataStructures;
        this.uiObjects = uiObjects;
    }

    /** Zeigt den Dialog an und lädt gegebenenfalls Gruppen herunter und installiert diese. */
    public void importGroups() {
        newestOwnListVersionEntries = NewestOwnListVersionListDownloader.download();

        if (newestOwnListVersionEntries.isEmpty()) {
            informUserAboutDownloadFailure("der eigenen Listen", uiObjects.getGuiLocation(),
                    uiObjects.getProgramImage());
        }
        else {
            interestAndVersionEntries = OwnListVersionAndInterestIo.loadOwnListVersionAndInterests();
            newerOrUnseenGroupNames = new ArrayList<>();
            downloadAndImportGroups();
        }
    }

    private void downloadAndImportGroups() {
        SwingUtilities.invokeLater(() -> downloadAndImportGroupsInEdt());
    }

    private void downloadAndImportGroupsInEdt() {
        GroupsDownloader downloader = new GroupsDownloader(dataStructures, uiObjects,
                newestOwnListVersionEntries, interestAndVersionEntries, newerOrUnseenGroupNames);
        downloader.download();
    }

}
