package de.duehl.zipwithzip4j.start.direct;

import java.io.IOException;

import de.duehl.basics.io.FileHelper;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.exception.ZipException;

public class DirectUnzipTestUnzipFolderWithPassword {

    public static void main(String[] args) {
        String dir = "c:\\temp\\zip4j_test_1";

        String zipFilename = FileHelper.concatPathes(dir,
                "daten_per_Programm_verpackt_mit_passwort.zip");
        String directoryToUnzip = FileHelper.concatPathes(dir,
                "daten_vom_Programm_ausgepackt_mit_passwort");
        FileHelper.createDirectoryIfNotExists(directoryToUnzip);

        String password = "Geheim";

        try (ZipFile zip = new ZipFile(zipFilename, password.toCharArray())) {
            zip.extractAll(directoryToUnzip);
        }
        catch (ZipException exception) {
            throw new RuntimeException(exception);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

}
