/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.collections;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.text.NumberString;
import java.util.ArrayList;
import java.util.List;

public class StringListComparer {
    private final List<String> list1;
    private final List<String> list2;
    private String description1;
    private String description2;
    private boolean equal;
    private String notEqualReason;

    public StringListComparer(List<String> list, List<String> list2) {
        this.list1 = list;
        this.list2 = list2;
        this.description1 = "der ersten Liste";
        this.description2 = "der zweiten Liste";
    }

    public void setDescription1(String string) {
        this.description1 = string;
    }

    public void setDescription2(String string) {
        this.description2 = string;
    }

    public void compare() {
        this.init();
        if (this.equal) {
            this.checkDifferentSizes();
        }
        if (this.equal) {
            this.checkNotContainedInOtherList();
        }
        if (this.equal) {
            this.checkDifferentSortOrder();
        }
    }

    private void init() {
        this.equal = true;
        this.notEqualReason = "";
    }

    private void checkDifferentSizes() {
        int n;
        int n2 = this.list1.size();
        if (n2 != (n = this.list2.size())) {
            this.equal = false;
            this.notEqualReason = "Die beiden Listen haben unterschiedlich viele Elemente. In " + this.description1 + " " + this.istSind(n2) + " " + NumberString.taupu(n2) + " " + this.xElementeText(n2) + " und in " + this.description2 + " " + this.istSind(n) + " " + NumberString.taupu(n) + " " + this.xElementeText(n) + ".";
        }
    }

    private void checkNotContainedInOtherList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String object : this.list1) {
            if (this.list2.contains(object)) continue;
            arrayList.add(object);
        }
        ArrayList arrayList2 = new ArrayList();
        for (String n2 : this.list2) {
            if (this.list1.contains(n2)) continue;
            arrayList2.add(n2);
        }
        if (!arrayList.isEmpty() || !arrayList2.isEmpty()) {
            if (arrayList.isEmpty()) {
                this.equal = false;
                int n = arrayList2.size();
                this.notEqualReason = "Es " + this.istSind(n) + " " + NumberString.taupu(n) + " " + this.xElementeText(n) + " in " + this.description1 + " nicht in " + this.description2 + " enthalten:\n" + CollectionsHelper.listListNice(arrayList2);
            } else if (arrayList2.isEmpty()) {
                this.equal = false;
                int n = arrayList.size();
                this.notEqualReason = "Es " + this.istSind(n) + " " + NumberString.taupu(n) + " " + this.xElementeText(n) + " in " + this.description2 + " nicht in " + this.description1 + " enthalten:\n" + CollectionsHelper.listListNice(arrayList);
            } else {
                this.equal = false;
                int n = arrayList2.size();
                int n2 = arrayList.size();
                this.notEqualReason = "Es " + this.istSind(n) + " " + NumberString.taupu(n) + " " + this.xElementeText(n) + " in " + this.description1 + " nicht in " + this.description2 + " enthalten:\n" + CollectionsHelper.listListNice(arrayList2) + "\nAu\u00dferdem " + this.istSind(n2) + " " + NumberString.taupu(n2) + " " + this.xElementeText(n2) + " in " + this.description2 + " nicht in " + this.description1 + " enthalten:\n" + CollectionsHelper.listListNice(arrayList);
            }
        }
    }

    private void checkDifferentSortOrder() {
        Object object;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this.list1.size(); ++i) {
            String string;
            object = this.list1.get(i);
            if (((String)object).equals(string = this.list2.get(i))) continue;
            arrayList.add(i);
        }
        if (!arrayList.isEmpty()) {
            this.equal = false;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("An den folgenden Positionen (1-basiert) weichen die beiden Listen von einander ab:\n");
            object = arrayList.iterator();
            while (object.hasNext()) {
                int n = (Integer)object.next();
                stringBuilder.append("    " + (n + 1) + ": '" + this.list1.get(n) + "' <-> '" + this.list2.get(n) + "'\n");
            }
            this.notEqualReason = stringBuilder.toString();
        }
    }

    private String xElementeText(int n) {
        return NumberString.germanPlural(n, "Elemente", "Element");
    }

    private String istSind(int n) {
        return NumberString.germanPlural(n, "sind", "ist");
    }

    public boolean isEqual() {
        return this.equal;
    }

    public String getNotEqualReason() {
        return this.notEqualReason;
    }
}

