/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.datetime.date;

import de.duehl.basics.datetime.date.ImmutualDate;
import de.duehl.basics.datetime.date.Weekday;
import de.duehl.basics.datetime.date.parse.DateParser;

public class DateCalculations {
    private DateCalculations() {
    }

    public static ImmutualDate parseDate(String string) {
        DateParser dateParser = new DateParser(string);
        return dateParser.parse();
    }

    public static boolean isLeapYear(int n) {
        return n % 4 == 0 && (n % 100 != 0 || n % 400 == 0);
    }

    public static int monthDays(ImmutualDate immutualDate) {
        return DateCalculations.monthDays(immutualDate.getMonth(), immutualDate.getYear());
    }

    public static int monthDays(int n, int n2) {
        switch (n) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                return 31;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
            case 2: {
                if (DateCalculations.isLeapYear(n2)) {
                    return 29;
                }
                return 28;
            }
        }
        throw new RuntimeException("Monat " + n + " nicht sinnvoll.");
    }

    public static ImmutualDate calculateEasterSunday(int n) {
        int n2 = n / 100;
        int n3 = 15 + (3 * n2 + 3) / 4 - (8 * n2 + 13) / 25;
        int n4 = 2 - (3 * n2 + 3) / 4;
        int n5 = n % 19;
        int n6 = (19 * n5 + n3) % 30;
        int n7 = (n6 + n5 / 11) / 29;
        int n8 = 21 + n6 - n7;
        int n9 = 7 - (n + n / 4 + n4) % 7;
        int n10 = 7 - (n8 - n9) % 7;
        int n11 = n8 + n10;
        ImmutualDate immutualDate = new ImmutualDate(n11, 3, n);
        return immutualDate.normalise();
    }

    public static Weekday dayOfTheWeek(int n, int n2, int n3) {
        if (n3 < 1592 || n3 > 2699) {
            throw new RuntimeException("Berechnung des Tages der Woche ist nur zwischen 1595 und 2699 m\u00f6glich.");
        }
        int n4 = n3 / 100;
        int n5 = n3 % 100;
        int n6 = 2 * (3 - n4 % 4);
        int n7 = n5 + n5 / 4;
        int n8 = 0;
        if (DateCalculations.isLeapYear(n3)) {
            n8 = 1;
        }
        int[] nArray = new int[]{1 - n8, 4 - n8, 4, 0, 2, 5, 0, 3, 6, 1, 4, 6};
        int n9 = nArray[n2 - 1];
        int n10 = n6 + n7 + n9 + n;
        --n10;
        return Weekday.getWeekdayByDayCodeStartingSunday(n10 %= 7);
    }
}

