/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.datetime.time;

import de.duehl.basics.text.NumberString;
import de.duehl.basics.text.Text;
import java.util.List;

public class ImmutualTime {
    private final int hour;
    private final int minute;
    private final int second;
    private final int dayCarryOver;

    public ImmutualTime() {
        this(0, 0, 0, 0);
    }

    public ImmutualTime(int n, int n2, int n3) {
        this(n, n2, n3, 0);
    }

    ImmutualTime(int n, int n2, int n3, int n4) {
        this.checkTime(n, n2, n3);
        this.hour = n;
        this.minute = n2;
        this.second = n3;
        this.dayCarryOver = n4;
    }

    public ImmutualTime(String string) {
        List<String> list = Text.splitByColon(string);
        for (String string2 : list) {
            if (NumberString.isDigitSequence(string2)) continue;
            throw new IllegalArgumentException("Unverst\u00e4ndliche Zeitangabe '" + string + "'.");
        }
        if (list.size() == 2) {
            list.add("0");
        }
        if (list.size() != 3) {
            throw new IllegalArgumentException("Unverst\u00e4ndliche Zeitangabe '" + string + "'.");
        }
        int n = NumberString.parseInt(list.get(0), "Die Stunde in '" + string + "' l\u00e4sst sich nicht parsen!");
        int n2 = NumberString.parseInt(list.get(1), "Die Minute in '" + string + "' l\u00e4sst sich nicht parsen!");
        int n3 = NumberString.parseInt(list.get(2), "Die Sekunde in '" + string + "' l\u00e4sst sich nicht parsen!");
        this.checkTime(n, n2, n3);
        this.hour = n;
        this.minute = n2;
        this.second = n3;
        this.dayCarryOver = 0;
    }

    private void checkTime(int n, int n2, int n3) {
        if (n < 0) {
            throw new IllegalArgumentException("Die Anzahl der Stunden darf nicht negativ sein.");
        }
        if (n > 23) {
            throw new IllegalArgumentException("Die Anzahl der Stunden darf h\u00f6chstens 23 sein.");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Die Anzahl der Minuten darf nicht negativ sein.");
        }
        if (n2 > 59) {
            throw new IllegalArgumentException("Die Anzahl der Minuten darf h\u00f6chstens 59 sein.");
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("Die Anzahl der Sekunden darf nicht negativ sein.");
        }
        if (n3 > 59) {
            throw new IllegalArgumentException("Die Anzahl der Sekunden darf h\u00f6chstens 59 sein.");
        }
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public int getDayCarryOver() {
        return this.dayCarryOver;
    }

    public String getHourAsTwoDigitString() {
        Object object = Integer.toString(this.hour);
        if (((String)object).length() < 2) {
            object = "0" + (String)object;
        }
        return object;
    }

    public String getMinuteAsTwoDigitString() {
        Object object = Integer.toString(this.minute);
        if (((String)object).length() < 2) {
            object = "0" + (String)object;
        }
        return object;
    }

    public String getSecondAsTwoDigitString() {
        Object object = Integer.toString(this.second);
        if (((String)object).length() < 2) {
            object = "0" + (String)object;
        }
        return object;
    }

    public String toString() {
        String string = this.getHourAsTwoDigitString() + ":" + this.getMinuteAsTwoDigitString() + ":" + this.getSecondAsTwoDigitString();
        return string + this.createCarryOverExtension();
    }

    private String createCarryOverExtension() {
        if (this.dayCarryOver == 0) {
            return "";
        }
        if (this.dayCarryOver == 1) {
            return " (+1 Tag)";
        }
        if (this.dayCarryOver > 1) {
            return " (+" + this.dayCarryOver + " Tage)";
        }
        if (this.dayCarryOver == -1) {
            return " (-1 Tag)";
        }
        if (this.dayCarryOver < -1) {
            return " (" + this.dayCarryOver + " Tage)";
        }
        throw new RuntimeException("Darf nicht auftreten!");
    }

    public String toStringWithoutSeconds() {
        String string = this.getHourAsTwoDigitString() + ":" + this.getMinuteAsTwoDigitString();
        return string + this.createCarryOverExtension();
    }

    public ImmutualTime addHours(int n) {
        int n2 = this.hour + n;
        int n3 = this.dayCarryOver;
        while (n2 > 23) {
            n2 -= 24;
            ++n3;
        }
        while (n2 < 0) {
            n2 += 24;
            --n3;
        }
        return new ImmutualTime(n2, this.minute, this.second, n3);
    }

    public ImmutualTime addMinutes(int n) {
        int n2 = this.minute + n;
        int n3 = 0;
        while (n2 > 59) {
            n2 -= 60;
            ++n3;
        }
        while (n2 < 0) {
            n2 += 60;
            --n3;
        }
        ImmutualTime immutualTime = new ImmutualTime(this.hour, n2, this.second, this.dayCarryOver);
        return immutualTime.addHours(n3);
    }

    public ImmutualTime addSeconds(int n) {
        int n2 = this.second + n;
        int n3 = 0;
        while (n2 > 59) {
            n2 -= 60;
            ++n3;
        }
        while (n2 < 0) {
            n2 += 60;
            --n3;
        }
        ImmutualTime immutualTime = new ImmutualTime(this.hour, this.minute, n2, this.dayCarryOver);
        return immutualTime.addMinutes(n3);
    }

    public ImmutualTime forgetDayCarryOver() {
        return new ImmutualTime(this.hour, this.minute, this.second);
    }

    public int difference(ImmutualTime immutualTime) {
        if (this.dayCarryOver != 0) {
            throw new RuntimeException("Keine Differenz bei vorhandendem \u00dcbertrag im Aufrufer!");
        }
        if (immutualTime.dayCarryOver != 0) {
            throw new IllegalArgumentException("Keine Differenz bei vorhandendem \u00dcbertrag im Argument!");
        }
        int n = immutualTime.second - this.second;
        int n2 = 60 * (immutualTime.minute - this.minute);
        int n3 = 3600 * (immutualTime.hour - this.hour);
        return n3 + n2 + n;
    }

    public boolean before(ImmutualTime immutualTime) {
        int n = this.difference(immutualTime);
        return n > 0;
    }

    public boolean after(ImmutualTime immutualTime) {
        int n = this.difference(immutualTime);
        return n < 0;
    }

    public ImmutualTime setSecondsToZero() {
        return new ImmutualTime(this.hour, this.minute, 0);
    }

    public void checkNoDayCarryOver() {
        if (this.dayCarryOver != 0) {
            throw new RuntimeException("Keine Differenz erlaubt!");
        }
    }

    public String asHhMmSs() {
        return String.format("%02d%02d%02d", this.hour, this.minute, this.second);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.dayCarryOver;
        n = 31 * n + this.hour;
        n = 31 * n + this.minute;
        n = 31 * n + this.second;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ImmutualTime immutualTime = (ImmutualTime)object;
        if (this.dayCarryOver != immutualTime.dayCarryOver) {
            return false;
        }
        if (this.hour != immutualTime.hour) {
            return false;
        }
        if (this.minute != immutualTime.minute) {
            return false;
        }
        return this.second == immutualTime.second;
    }
}

