/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.datetime.time;

import de.duehl.basics.datetime.time.ImmutualTime;
import de.duehl.basics.datetime.time.data.HoursMinutesSeconds;
import de.duehl.basics.text.NumberString;
import de.duehl.basics.text.Text;
import java.util.Calendar;
import java.util.List;

public class TimeHelper {
    public static final long ONE_HOUR_MILLIS = 3600000L;
    public static final long ONE_DAY_MILLIS = 86400000L;

    private TimeHelper() {
    }

    public static long getCurrentTimeInMilliseconds() {
        return System.currentTimeMillis();
    }

    public static long hoursMinutesSecondsToSeconds(String string) {
        if (!string.matches("\\d{2,}:\\d\\d:\\d\\d")) {
            throw new IllegalArgumentException("Falsches Format, erwartet wird HH:MM:SS (z.B. \"02:24:31\") bekommen haben wir \"" + string + "\".");
        }
        List<String> list = Text.splitByColon(string);
        if (list.size() != 3) {
            throw new IllegalArgumentException("Falsches Format, erwartet wird HH:MM:SS (z.B. \"02:24:31\") bekommen haben wir \"" + string + "\".");
        }
        String string2 = list.get(0);
        String string3 = list.get(1);
        String string4 = list.get(2);
        long l = NumberString.parseLong(string2, string2 + " l\u00e4sst sich nicht zu long parsen");
        long l2 = NumberString.parseLong(string3, string3 + " l\u00e4sst sich nicht zu long parsen");
        long l3 = NumberString.parseLong(string4, string4 + " l\u00e4sst sich nicht zu long parsen");
        return l * 60L * 60L + l2 * 60L + l3;
    }

    public static String secondsToHoursMinutesSeconds(long l) {
        if (l < 0L) {
            return "ERROR";
        }
        HoursMinutesSeconds hoursMinutesSeconds = TimeHelper.secondsToHoursMinutesSecondsInternal(l);
        return hoursMinutesSeconds.toFormattedString();
    }

    public static String secondsToHoursMinutesSecondsSinceMidnight(long l) {
        if (l < 0L) {
            return "ERROR";
        }
        HoursMinutesSeconds hoursMinutesSeconds = TimeHelper.secondsToHoursMinutesSecondsInternal(l);
        hoursMinutesSeconds.cutToSinceMidnight();
        return hoursMinutesSeconds.toFormattedString();
    }

    private static HoursMinutesSeconds secondsToHoursMinutesSecondsInternal(long l) {
        long l2 = l;
        long l3 = l2 % 60L;
        l2 -= l3;
        long l4 = (l2 /= 60L) % 60L;
        l2 -= l4;
        long l5 = l2 /= 60L;
        return new HoursMinutesSeconds(l5, l4, l3);
    }

    public static String milliSecondsToHoursMinutesSecondsMilliSeconds(long l) {
        if (l < 0L) {
            return "ERROR";
        }
        long l2 = l / 1000L;
        long l3 = l - 1000L * l2;
        String string = TimeHelper.secondsToHoursMinutesSeconds(l2);
        return String.format("%s:%03d", string, l3);
    }

    public static String milliSecondsToHoursMinutesSecondsMilliSecondsBraces(long l) {
        if (l < 0L) {
            return "ERROR";
        }
        long l2 = l / 1000L;
        long l3 = l - 1000L * l2;
        String string = TimeHelper.secondsToHoursMinutesSeconds(l2);
        return String.format("%s(%03d)", string, l3);
    }

    public static String addHourMinutesSecondsToHourMinutesSeconds(String string, String string2) {
        long l = TimeHelper.hoursMinutesSecondsToSeconds(string);
        long l2 = TimeHelper.hoursMinutesSecondsToSeconds(string2);
        long l3 = l + l2;
        return TimeHelper.secondsToHoursMinutesSeconds(l3);
    }

    public static ImmutualTime actualTime() {
        Calendar calendar = Calendar.getInstance();
        return TimeHelper.calendarToTime(calendar);
    }

    public static String actualTimeAsString() {
        Calendar calendar = Calendar.getInstance();
        ImmutualTime immutualTime = TimeHelper.calendarToTime(calendar);
        return immutualTime.toString();
    }

    public static ImmutualTime calendarToTime(Calendar calendar) {
        int n = calendar.get(11);
        int n2 = calendar.get(12);
        int n3 = calendar.get(13);
        return new ImmutualTime(n, n2, n3);
    }

    public static boolean isHhMmTime(String string) {
        if (string.length() != 5) {
            return false;
        }
        String string2 = string.substring(0, 1);
        String string3 = string.substring(1, 2);
        String string4 = string.substring(2, 3);
        String string5 = string.substring(3, 4);
        String string6 = string.substring(4, 5);
        if (!TimeHelper.is0or1or2(string2)) {
            return false;
        }
        if (!TimeHelper.is0to9(string3)) {
            return false;
        }
        if (!string4.equals(":")) {
            return false;
        }
        if (!TimeHelper.is0to5(string5)) {
            return false;
        }
        if (!TimeHelper.is0to9(string6)) {
            return false;
        }
        return !string2.equals("2") || TimeHelper.is0to3(string3);
    }

    public static boolean is0or1or2(String string) {
        return string.equals("0") || string.equals("1") || string.equals("2");
    }

    public static boolean is0to3(String string) {
        return string.equals("0") || string.equals("1") || string.equals("2") || string.equals("3");
    }

    public static boolean is0to5(String string) {
        return string.equals("0") || string.equals("1") || string.equals("2") || string.equals("3") || string.equals("4") || string.equals("5");
    }

    public static boolean is0to9(String string) {
        return string.equals("0") || string.equals("1") || string.equals("2") || string.equals("3") || string.equals("4") || string.equals("5") || string.equals("6") || string.equals("7") || string.equals("8") || string.equals("9");
    }

    public static long runtimeToSeconds(String string) {
        List<String> list = Text.splitByColon(string);
        if (list.size() != 3) {
            return -1L;
        }
        String string2 = list.get(0);
        long l = NumberString.parseLongIgnore(string2, -1L);
        if (l == -1L) {
            return -1L;
        }
        String string3 = list.get(1);
        long l2 = NumberString.parseIntIgnore(string3, -1);
        if (l2 == -1L) {
            return -1L;
        }
        String string4 = list.get(2);
        long l3 = NumberString.parseIntIgnore(string4, -1);
        if (l3 == -1L) {
            return -1L;
        }
        return l * 60L * 60L + l2 * 60L + l3;
    }

    public static String secondsToRuntime(long l) {
        if (l < 0L) {
            return "unbekannt";
        }
        long l2 = l;
        long l3 = l2 % 60L;
        l2 -= l3;
        long l4 = (l2 /= 60L) % 60L;
        l2 -= l4;
        long l5 = l2 /= 60L;
        return NumberString.addLeadingZeroes(l5, 2) + ":" + NumberString.addLeadingZeroes(l4, 2) + ":" + NumberString.addLeadingZeroes(l3, 2);
    }

    public static String summerizeHourMinuteSeconds(String ... stringArray) {
        long l = 0L;
        for (String string : stringArray) {
            long l2 = TimeHelper.hoursMinutesSecondsToSeconds(string);
            l += l2;
        }
        String string = TimeHelper.secondsToHoursMinutesSeconds(l);
        return string;
    }

    public static String insertTimeColonsHHMMSS(String string) {
        if (!NumberString.isDigitSequence(string) || string.length() != 6) {
            return string;
        }
        String string2 = string.substring(0, 2);
        String string3 = string.substring(2, 4);
        String string4 = string.substring(4, 6);
        return string2 + ":" + string3 + ":" + string4;
    }

    public static String secondsToMinutesSeconds(int n) {
        int n2 = n / 60;
        int n3 = n % 60;
        String string = n3 < 10 ? ":0" : ":";
        return n2 + string + n3;
    }
}

